////////////////////////////////////////////////////////////////////////////
//
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
//
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC
// file. If your distribution of this software does not contain
// a LICENSE.DOC file then you have no rights to use this
// software in any manner and should contact DSTC at the address
// below to determine an appropriate licensing arrangement.
//
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
//
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
//
////////////////////////////////////////////////////////////////////////////

package com.dstc.security.kerberos;

/**
 * <p> General Kerberos exception, representing an exceptional condition in
 * using the Kerberos service.
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public class KerberosException extends Exception
{
    // add error codes and error messages tables, constructor taking a code
    // nt 1999/05/22

    // Standard error codes
    public static final int NO_ERROR = 0;
    public static final int KDC_ERR_NAME_EXP = 1;
    public static final int KDC_ERR_SERVICE_EXP = 2;
    public static final int KDC_ERR_BAD_PVNO = 3;
    public static final int KDC_ERR_C_OLD_MAST_KVNO = 4;
    public static final int KDC_ERR_S_OLD_MAST_KVNO = 5;
    public static final int KDC_ERR_C_PRINCIPAL_UNKNOWN = 6;
    public static final int KDC_ERR_S_PRINCIPAL_UNKNOWN = 7;
    public static final int KDC_ERR_PRINCIPAL_NOT_UNIQUE = 8;
    public static final int KDC_ERR_NULL_KEY = 9;
    public static final int KDC_ERR_CANNOT_POSTDATE = 10;
    public static final int KDC_ERR_NEVER_VALID = 11;
    public static final int KDC_ERR_POLICY = 12;
    public static final int KDC_ERR_BADOPTION = 13;
    public static final int KDC_ERR_ETYPE_NOSUPP = 14;
    public static final int KDC_ERR_SUMTYPE_NOSUPP = 15;
    public static final int KDC_ERR_PADATA_TYPE_NOSUPP = 16;
    public static final int KDC_ERR_TRTYPE_NOSUPP = 17;
    public static final int KDC_ERR_CLIENT_REVOKED = 18;
    public static final int KDC_ERR_SERVICE_REVOKED = 19;
    public static final int KDC_ERR_TGT_REVOKED = 20;
    public static final int KDC_ERR_CLIENT_NOTYET = 21;
    public static final int KDC_ERR_SERVICE_NOTYET = 22;
    public static final int KDC_ERR_KEY_EXPIRED = 23;
    public static final int KDC_ERR_PREAUTH_FAILED = 24;
    public static final int KDC_ERR_PREAUTH_REQUIRED = 25;
    public static final int KDC_ERR_SERVER_NOMATCH = 26;
    public static final int KDC_ERR_MUST_USE_USER2USER = 27;
    public static final int KDC_ERR_PATH_NOT_ACCEPTED = 28;
    // 29, 30 are placeholders
    public static final int KRB_AP_ERR_BAD_INTEGRITY = 31;
    public static final int KRB_AP_ERR_TKT_EXPIRED = 32;
    public static final int KRB_AP_ERR_TKT_NYV = 33;
    public static final int KRB_AP_ERR_REPEAT = 34;
    public static final int KRB_AP_ERR_NOT_US = 35;
    public static final int KRB_AP_ERR_BADMATCH = 36;
    public static final int KRB_AP_ERR_SKEW = 37;
    public static final int KRB_AP_ERR_BADADDR = 38;
    public static final int KRB_AP_ERR_BADVERSION = 39;
    public static final int KRB_AP_ERR_MSG_TYPE = 40;
    public static final int KRB_AP_ERR_MODIFIED = 41;
    public static final int KRB_AP_ERR_BADORDER = 42;
    // 43 is placeholder
    public static final int KRB_AP_ERR_BADKEYVER = 44;
    public static final int KRB_AP_ERR_NOKEY = 45;
    public static final int KRB_AP_ERR_MUT_FAILED = 46;
    public static final int KRB_AP_ERR_BADDIRECTION = 47;
    public static final int KRB_AP_ERR_METHOD = 48;
    public static final int KRB_AP_ERR_BADSEQ = 49;
    public static final int KRB_AP_ERR_INAPP_CKSUM = 50;
    public static final int KRB_AP_PATH_NOT_ACCEPTED = 51;
    // 52-59 are placeholders
    public static final int KRB_ERR_GENERIC = 60;
    public static final int KRB_ERR_FIELD_TOOLONG = 61;
    // 62-127 are placeholders
    // Implementation specific error codes
    public static final int KRB_IMPL_ERR_CONFIG = 128;

    // Error codes boundary values
    private static final int MIN_STD_ERR = 0;
    private static final int MAX_STD_ERR = 61;
    private static final int MIN_IMPL_ERR = 128;
    private static final int MAX_IMPL_ERR = 128;

    // table of error messages corresponding to error codes
    private static final String stdErrMessages[] =
        {"No error",
         "Client's entry in the database has expired",
         "Server's entry in the database has expired",
         "Requested protocol version not supported",
         "Client's key is encrypted in an old master key",
         "Server's key is encrypted in an old master key",
         "Client not found in Kerberos database",
         "Server not found in Kerberos database",
         "Principal has multiple entries in Kerberos database",
         "Client or server has a null key",
         "Ticket is ineligible for postdating",
         "Requested effective lifetime is negative or too short",
         "KDC policy rejects request",
         "KDC can't fulfill requested option",
         "KDC has no support for encryption type",
         "KDC has no support for checksum type",
         "KDC has no support for padata type",
         "KDC has no support for transited type",
         "Clients credentials have been revoked",
         "Credentials for server have been revoked",
         "TGT has been revoked",
         "Client not yet valid - try again later",
         "Server not yet valid - try again later",
         "Password has expired - change password to reset",
         "Pre-authentication information was invalid",
         "Additional pre-authentication required",
         "Requested server and ticket don't match",
         "Server principal valid for user2user only",
         "KDC policy rejects transited path",
         "", "",           // placeholders 29, 30
         "Integrity checked on decrypted field failed",
         "Ticket expired",
         "Ticket not yet valid",
         "Request is a replay",
         "The ticket isn't for us",
         "Ticket and authenticator don't match",
         "Clock skew too great",
         "Incorrect net address",
         "Protocol version mismatch",
         "Invalid message type",
         "Message stream modified",
         "Message out of order",
         "",              // placeholder 43
         "Specified version of key is not available",
         "Service key not available",
         "Mutual authentication failed",
         "Incorrect message direction",
         "Alternative authentication method required",
         "Incorrect sequence number in message",
         "Inappropriate type of checksum in message",
         "Policy rejects transited path",
         "", "", "", "", "", "", "", "",  // placeholder 52-59
         "Generic error (description in e-text)",
         "Field is too long for this implementation"
        };

    private static final String implErrMessages[] =
        {"Error in configuration file"
        };

    private static String code2Message(int code)
    {
        // handle placeholders
        if ((code < MIN_STD_ERR)
            || ((code > MAX_STD_ERR) && (code < MIN_IMPL_ERR))
            || (code > MAX_IMPL_ERR) || (code == 29) || (code == 30)
            || (code == 43) || ((code > 51) && (code < 60)))
            code = KRB_ERR_GENERIC;

        // std and impl error messages are in separate tables
        if (code < MIN_IMPL_ERR)
            return stdErrMessages[code];
        else
            return implErrMessages[code - MIN_IMPL_ERR];
    }

    /**
     * Construct a KerberosException with a specific error code. The error
     * code must be one of the pre-defined error codes specified in this
     * class. If an error code outside the valid ranges is specified as the
     * parameter the code KRB_ERR_GENERIC is used.
     *
     * @param code The error code
     */
    public KerberosException(int code)
    {
        super(code2Message(code));
    }

  /**
   */
  public KerberosException()
  {
    super();
  }

  /**
   *
   * @param msg the detail message.
   */
  public KerberosException(String msg)
  {
    super(msg);
  }
}
