package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.kerberos.v5.BadMessageTypeException;

class KerberosMessageFactory
{
  static KerberosMessage getKDCMessage(byte[] encoding)
    throws KerberosException
  {
    //Check for error message
    try
    {
      KerberosError error = new KerberosError(encoding);
      throw new KerberosException(error.getMessage());
    }
    catch (Asn1Exception e)
    {
      //ignore
    }
    catch (ClassCastException e)
    {
      //ignore
    }

    try
    {
      return new TGSResponse(encoding);
    }
    catch (Asn1Exception e)
    {
      //ignore
    }
    catch (ClassCastException e)
    {
      //ignore
    }
    catch (BadMessageTypeException e)
    {
      //ignore
    }

    try
    {
      return new ASResponse(encoding);
    }
    catch (Asn1Exception e)
    {
      //ignore
    }
    catch (ClassCastException e)
    {
      //ignore
    }

    throw new KerberosException("Unknown message");
  }
}



