//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.creds;

import java.io.InputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

/**
 * A FilterInputStream for the credential cache
 *
 * @version 0.98, 98/11/01
 * @author Ming Yung
 */
final class CCInputStream extends DataInputStream
{
  /**
   * Constructs a CCInputStream from an InputStream
   */
  public CCInputStream(InputStream is)
  {
    super(is);
  }

  public int available() throws IOException
  {
    return super.available();
  }

/*
  public byte readByte() throws IOException
  {
    int ret = read();

    if (ret == -1)
      throw new IOException("Unexpected end of data");

    return (byte)(ret & 0xff);
  }

  public short readShort() throws IOException
  {
    byte[] temp = new byte[2];

    if (read(temp) == -1)
      throw new IOException("Unexpected end of data");

    return (short)(((temp[0] & 0xff) << 8) | (temp[1] & 0xff));
  }

  public int readInt() throws IOException
  {
    byte[] temp = new byte[4];

    if (read(temp) != -1)
    {
      int retval = 0;
      for (int j=0; j < 4; j++)
      {
        retval += (int) (temp[j] & 0xff) << 8*((3-j)%4);
      }
      return retval;
    }
    else
      throw new IOException("Unexpected end of data");
  }
*/

  public byte[] readBinaryString() throws IOException
  {
    int length = readInt();
    if (length == -1) return null;

    byte[] retval = new byte[length];
    //if(read(retval) != -1)
    //  return retval;
    //else
    //  return null;
    readFully(retval);
    return retval;
  }
}
