//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.creds;

import java.io.*;
import java.util.*;

/**
 * A KeyTab implementing the MIT v5 keytab
 *
 * @author Ming Yung
 */
final class FileKeyTab extends KeyTab
{
  private Hashtable entries;
  private String fileName;
  private String defaultUser;

  FileKeyTab(String fileName) throws IOException
  {
    this.fileName = fileName;
    entries = new Hashtable();
    load(fileName);
    this.defaultUser = ctx.getUsername();
  }

  synchronized void load(String name) throws IOException
  {
    FileInputStream is = new FileInputStream(name);
    CCInputStream outer = new CCInputStream(new BufferedInputStream(is));
    outer.readShort(); 
    while (true)
    {
      if (outer.available() == 0) break;

      int entryLength = outer.readInt();
      byte[] entryBytes = new byte[entryLength];
      outer.read(entryBytes);
      CCInputStream inner 
        = new CCInputStream(new ByteArrayInputStream(entryBytes));
      this.readEntry(inner);
    }
  }

  private void readEntry(CCInputStream is) throws IOException
  {
    KeyTabEntry entry = new KeyTabEntry(is);
    this.entries.put(entry.getServiceName(), entry);
  }

  /**
   * Returns the key for the specified service
   */
  public byte[] getKey(String serviceName)
  {
    KeyTabEntry entry = (KeyTabEntry)this.entries.get(serviceName);
    if (entry != null)
      return entry.getKeyBytes();
    else
      return null;
  }

  public KeyTabEntry getKeyTabEntry(String serviceName)
  {
    return (KeyTabEntry)this.entries.get(serviceName);
  }

  public String getKeyTabType()
  {
    return "File";
  }

  public Iterator getKeyTabEntries()
  {
    return this.entries.values().iterator();
  }

  /**
   * Returns a string representation of this KeyTab
   */
  public String toString()
  {
    StringBuffer sb = new StringBuffer();

    Enumeration enum = this.entries.elements();
    while (enum.hasMoreElements())
    {
      sb.append("\n");
      sb.append(((KeyTabEntry)enum.nextElement()).toString());
    }
    return sb.toString();
  }
}
