//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.crypto;

import java.security.Security;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.SecretKey;

/**
 * A representation of a key used in Kerberos. Supports the DES pass-string
 * to key transformation
 *
 * @version 0.98, 98/11/01
 * @author Ming Yung
 */
public class KerberosKey implements KeyMaterial
{
  private int type;
  private byte[] keyBytes = null;

  public KerberosKey(int keyType, byte[] bytes)
  {
    this.type = keyType;
    this.keyBytes = bytes;
  }

  public KerberosKey(int keyType, String passString)
  {
    this.type = keyType;
    this.keyBytes = desStringToKey(passString);
  }

  public void setKeyBytes(byte[] bytes)
  {
    this.keyBytes = bytes;
  }

  public int getKeyType()
  {
    return this.type;
  }

  public byte[] getKeyBytes()
  {
    return this.keyBytes;
  }

  private static byte[] desStringToKey(String string)
  {
    byte retval[] = new byte[8];
    byte str[] = string.getBytes();
    byte j;

    try
    {
      //Fan-folding
      for (int i=0; i<str.length; i++)
      {
        j=str[i];
        if ((i%16) < 8)
          retval[i%8]^=(j<<1);
        else
        {
          j=(byte)(((j<<4) & 0xf0) | ((j>>4) & 0x0f));
          j=(byte)(((j<<2) & 0xcc) | ((j>>2) & 0x33));
          j=(byte)(((j<<1) & 0xaa) | ((j>>1) & 0x55));
          retval[7-(i%8)]^=j;
        }
      }

      //Force odd parity
      forceOddParity(retval);

      //Use as key and iv to generate DES-MAC of original string
      Mac mac = Mac.getInstance("DES-MAC");

      SecretKeySpec key = new SecretKeySpec(retval, "DES");
      IvParameterSpec ivSpec2 = new IvParameterSpec(retval);

      mac.init(key, ivSpec2);
      retval = mac.doFinal(string.getBytes());
      mac.reset();

      //Force odd parity
      forceOddParity(retval);

      return retval;
    }
    catch (Exception e)
    {
      e.printStackTrace();
      return null;
    }
  }

  private static final void forceOddParity(byte in[])
  {
    int score;
    for (int j=0; j < in.length; j++)
    {
      score = 0;
      for (int i=7; i>=0; i--)
      {
        score += (in[j] >>> i) & 0x1;
      }
      if (0 == score % 2) in[j] ^= 0x1;
    }
  }

  protected static void debug(String msg, byte bytes[])
  {
    System.out.print(msg);
    for (int i=0; i<bytes.length; i++)
    {
      System.out.print(java.lang.Integer.toHexString(bytes[i] & 0xff) + " ");
    }
    System.out.println(" ");
  }
}
