//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.gssapi;

/**
 * This class implements functionality common to the entire GSS-API
 * package. It does not define any public constructors and all its
 * methods are static.
 *
 * @author Anthony Ho
 */
public class GSSManager
{
  static final Oid KRB5 = new Oid("1.2.840.113554.1.2.2");

  /**
   * Returns an array of Oid objects, one for each mechanism available
   * within this GSS-API package. A "null" value is returned when no
   * mechanism are available (an example of this would be when mechanism
   * are dynamically configured, and currently no mechanisms are
   * installed).
   */
  public static Oid[] getMechs()
  {
    // Create array of supported mechnisms
    Oid[] mechs = {KRB5};
    return mechs;
  }

  /**
   * Returns name types Oids supported by the specified mechanism.
   */
  public static Oid[] getNamesForMech(Oid mech) throws GSSException
  {
    // One block for each supported mechanism
    // Create an array of supported name types for that mechanism
    if (mech.equals(KRB5))
    {
      Oid[] nameTypes = {GSSName.NT_HOSTBASED_SERVICE,
                         GSSName.NT_HOSTBASED_ALT,
                         GSSName.NT_USER_NAME,
                         GSSName.NT_EXPORT_NAME,
                         GSSName.KRB5_NT_PRINCIPAL_NAME};
      return nameTypes;
    }
    else
      throw new GSSException(GSSException.BAD_MECH);
  }

  /**
   * Returns an array of Oid objects, one for each mechanisms that support
   * the specific name type.  "null" is returned when no mechanisms are
   * found to support the specified name type.
   */
  public static Oid[] getMechsForName(Oid nameType)
  {
    // One block for each supported name type
    // Create an array of mechanisms which support that name type
    if (nameType.equals(GSSName.NT_HOSTBASED_SERVICE)
        || nameType.equals(GSSName.NT_HOSTBASED_ALT))
    {
      Oid[] mechs = {KRB5};
      return mechs;
    }
    else if (nameType.equals(GSSName.NT_USER_NAME))
    {
      Oid[] mechs = {KRB5};
      return mechs;
    }
    else if (nameType.equals(GSSName.NT_EXPORT_NAME))
    {
      Oid[] mechs = {KRB5};
      return mechs;
    }
    else if (nameType.equals(GSSName.KRB5_NT_PRINCIPAL_NAME))
    {
      Oid[] mechs = {KRB5};
      return mechs;
    }
    else
      return null;
  }

  /**
   * Returns the default mechanism oid.  This is the mechanisms that will
   * be used when a "null" Oid object is specified in place of an Oid
   * object within GSSCredential and GSSContext methods.
   */
  public static Oid getDefaultMech()
  {
    return KRB5;
  }
}
