//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.gssapi;

/**
 * This is a utility class used within the per-message GSSContext
 * methods to convey per-message properties.
 *
 * <p>When used with the GSSContext class wrap and getMIC methods, an
 * instance of this class is used to indicate the desired QOP and to
 * request if confidentiality services are to be applied to caller
 * supplied data (wrap only).  To request default QOP, the value of 0
 * should be used.
 *
 * <p>When used with the unwrap and verifyMIC methods of the GSSContext
 * class, an instance of this class will be used to indicate the applied
 * QOP and confidentiality services over the supplied message. In the
 * case of verifyMIC, the confidentiality state will always be "false".
 * Upon return from these methods, this object will also contain any
 * supplementary status values applicable to the processed token.  The
 * supplementary status values can indicate old tokens, out of sequence
 * tokens, gap tokens or duplicate tokens.
 *
 * @author Anthony Ho
 */
public class MessageProp
{
  private int qop;
  private boolean privState;
  private boolean duplicateToken = false;
  private boolean oldToken = false;
  private boolean unSeqToken = false;
  private boolean gapToken = false;

  /**
   * Default constructor for the class. QOP is set to 0 and
   * confidentiality to "false".
   */
  public MessageProp()
  {
    this.qop = 0;
    this.privState = false;
  }

  /**
   * Constructor which sets the values for the qop and privacy state.
   */
  public MessageProp(int qop, boolean privState)
  {
    this.qop = qop;
    this.privState = privState;
  }

  /**
   * Retrieves the QOP value.
   */
  public int getQOP()
  {
    return this.qop;
  }

  /**
   * Retrieves the privacy state.
   */
  public boolean getPrivacy()
  {
    return this.privState;
  }

  /**
   * Sets the QOP value.
   */
  public void setQOP(int qopVal)
  {
    this.qop = qopVal;
  }

  /**
   * Sets the privacy state.
   */
  public void setPrivacy(boolean privState)
  {
    this.privState = privState;
  }

  /**
   * Returns "true" if this is a duplicate of an earlier token.
   */
  public boolean isDuplicateToken()
  {
    return duplicateToken;
  }

  /**
   * Sets the duplicate token status value.
   */
  public void setDuplicateToken(boolean state)
  {
    this.duplicateToken = state;
  }

  /**
   * Returns "true" if the token's validity period has expired.
   */
  public boolean isOldToken()
  {
    return oldToken;
  }

  /**
   * Sets the old token status value.
   */
  public void setOldToken(boolean state)
  {
    this.oldToken = state;
  }

  /**
   * Returns "true" if a later token has already been processed.
   */
  public boolean isUnseqToken()
  {
    return unSeqToken;
  }

  /**
   * Sets the unsequenced token status value.
   */
  public void setUnSeqToken(boolean state)
  {
    this.unSeqToken = state;
  }

  /**
   * Returns "true" if an expected per-message token was not received.
   */
  public boolean isGapToken()
  {
    return gapToken;
  }

  /**
   * Sets the gap token status value.
   */
  public void setGapToken(boolean state)
  {
    this.gapToken = state;
  }
}
