//XXXNeeds Constructor for KDC
//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.v5;

import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.BadMessageTypeException;
import com.dstc.security.kerberos.v5.base.*;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import com.dstc.security.kerberos.v5.creds.Ticket;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Explicit;

/**
 * <p>A class representing the Kerberos ASN.1 structure KDC-REP.
 *
 * <pre>
 *   KDC-REP ::= SEQUENCE {
 *                 pvno[0]                    INTEGER,
 *                 msg-type[1]                INTEGER,
 *                 padata[2]                  SEQUENCE OF PA-DATA OPTIONAL,
 *                 crealm[3]                  Realm,
 *                 cname[4]                   PrincipalName,
 *                 ticket[5]                  Ticket,
 *                 enc-part[6]                EncryptedData
 *               }
 * </pre>
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class KDCRep extends Sequence
{
  private int pvno = 5;
  private int msgType;
  private Realm cRealm;
  private PrincipalName cName;
  private Ticket ticket;
  private EncryptedData encPart;

  public KDCRep() {}

  /**
   * Constructs a KDCRep from a DER encoding
   */
  public KDCRep(byte encoded[]) throws Asn1Exception, BadVersionException
  {
    doDecode(encoded);
    int i=0;
    
    Explicit exp = (Explicit)components.elementAt(i++);
    if (((com.dstc.security.asn1.Integer)exp.getComponent()).getInt() != pvno)
      throw new BadVersionException("Not version 5");

    exp = (Explicit)components.elementAt(i++);
    this.msgType 
      = ((com.dstc.security.asn1.Integer)exp.getComponent()).getInt();

    exp = (Explicit)components.elementAt(i);
    if (exp.getTagNumber() == 2) 
    {
      // TODO: store and/or process pa-data here
      i++;
    }

    exp = (Explicit)components.elementAt(i++);
    this.cRealm = new Realm(exp.getComponent().encode());

    exp = (Explicit)components.elementAt(i++);
    this.cName = new PrincipalName(exp.getComponent().encode());

    exp = (Explicit)components.elementAt(i++);
    this.ticket = new Ticket(exp.getComponent().encode());

    exp = (Explicit)components.elementAt(i++);
    this.encPart = new EncryptedData(exp.getComponent().encode());
  }

  /**
   * Returns the encrypted part of this KDCRep
   */
  public EncryptedData getEncrypted()
  {
    return this.encPart;
  }

  /**
   * Returns the message type for this KDCRep
   */
  public int getMsgType()
  {
    return this.msgType;
  }

  /**
   * Returns the ticket for this KDCRep
   */
  public Ticket getTicket()
  {
    return this.ticket;
  }

  /**
   * Returns the client realm for this KDCRep
   */
  public Realm getClientRealm()
  {
    return this.cRealm;
  }

  /**
   * Returns the client name for this KDCRep
   */
  public PrincipalName getClientName()
  {
    return this.cName;
  }
}
