//XXXNeeds Constructor for KDC
//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.v5;

import java.util.Vector;

import com.dstc.security.kerberos.v5.base.*;

import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.OctetString;

/**
 * <p> Implements the ASN.1 structure KRB-ERROR.
 *
 * <pre>
 * KRB-ERROR ::=   [APPLICATION 30] SEQUENCE {
 *                   pvno[0]               INTEGER,
 *                   msg-type[1]           INTEGER,
 *                   ctime[2]              KerberosTime OPTIONAL,
 *                   cusec[3]              INTEGER OPTIONAL,
 *                   stime[4]              KerberosTime,
 *                   susec[5]              INTEGER,
 *                   error-code[6]         INTEGER,
 *                   crealm[7]             Realm OPTIONAL,
 *                   cname[8]              PrincipalName OPTIONAL,
 *                   realm[9]              Realm, -- Correct realm
 *                   sname[10]             PrincipalName, -- Correct name
 *                   e-text[11]            GeneralString OPTIONAL,
 *                   e-data[12]            OCTET STRING OPTIONAL
 *                 }
 * </pre>
 *
 * @version 0.99, 98/12/20
 * @author Ming Yung
 */
public final class KrbError extends Explicit
{
  public static final int TAG_KRB_ERROR = 30;
  private int pvno;
  private int msgType;
  private KerberosTime ctime = null;
  private int cusec = 0;
  private KerberosTime stime;
  private int susec;
  private int errorCode;
  private Realm crealm = null;
  private PrincipalName cname = null;
  private Realm realm;
  private PrincipalName sname;
  private String eText = null;
  private byte[] eData = null;

  /**
   * Constructs a KrbError from a DER encoding
   */
  public KrbError(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);

    int i=0;

    Sequence seq = (Sequence)this.getComponent();
    Vector comps = seq.getComponents();

    Explicit exp = (Explicit)comps.elementAt(i++);
    this.pvno = ((com.dstc.security.asn1.Integer)exp.getComponent()).getInt();

    exp = (Explicit)comps.elementAt(i++);
    this.msgType = 
      ((com.dstc.security.asn1.Integer)exp.getComponent()).getInt();

    exp = (Explicit)comps.elementAt(i);
    if (exp.getTagNumber() == 2)
    {
      i++;
      this.ctime = new KerberosTime(exp.getComponent().encode());
    }

    exp = (Explicit)comps.elementAt(i);
    if (exp.getTagNumber() == 3)
    {
      i++;
      this.cusec 
        = ((com.dstc.security.asn1.Integer)exp.getComponent()).getInt();
    }

    exp = (Explicit)comps.elementAt(i++);
    this.stime = new KerberosTime(exp.getComponent().encode());
  
    exp = (Explicit)comps.elementAt(i++);
    this.susec 
      = ((com.dstc.security.asn1.Integer)exp.getComponent()).getInt();

    exp = (Explicit)comps.elementAt(i++);
    this.errorCode 
      = ((com.dstc.security.asn1.Integer)exp.getComponent()).getInt();

    exp = (Explicit)comps.elementAt(i);
    if (exp.getTagNumber() == 7)
    {
      i++;
      this.crealm = new Realm(exp.getComponent().encode());
    }

    exp = (Explicit)comps.elementAt(i);
    if (exp.getTagNumber() == 8)
    {
      i++;
      this.cname = new PrincipalName(exp.getComponent().encode());
    }

    exp = (Explicit)comps.elementAt(i++);
    this.realm = new Realm(exp.getComponent().encode());

    exp = (Explicit)comps.elementAt(i++);
    this.sname = new PrincipalName(exp.getComponent().encode());

    if (i == comps.size()) return;

    exp = (Explicit)comps.elementAt(i);
    if (exp.getTagNumber() == 11)
    {
      i++;
      this.eText = ((GeneralString)exp.getComponent()).getName();
    }

    if (i == comps.size()) return;

    exp = (Explicit)comps.elementAt(i);
    if (exp.getTagNumber() == 12)
    {
      i++;
      this.eData = ((OctetString)exp.getComponent()).getBytes();
    }
  }

  /**
   * Returns the error message
   */
  public String getMessage()
  {
    return this.eText;
  }
}
