//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.v5;

import com.dstc.security.kerberos.v5.base.*;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import com.dstc.security.kerberos.v5.creds.Ticket;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Explicit;

/**
 * <p>A class representing the Kerberos ASN.1 structure Krb-TGS-REP.
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class KrbTGSRep extends Explicit
{
  public static final int TAG_KRB_TGS_REP = 13;

  private KDCRep rep;

  /**
   * Constructs a KrbTGSRep from a KDCRep
   */
  public KrbTGSRep(KDCRep rep) 
  {
    super(Asn1.TAG_CLASS_APPLICATION, TAG_KRB_TGS_REP);

    this.rep = rep;
    addComponent(rep);
  }

  /**
   * Constructs a KrbTGSRep from a DER encoding
   */
  public KrbTGSRep(byte encoded[]) 
    throws Asn1Exception, BadVersionException, BadMessageTypeException
  {
    doDecode(encoded);
    if (this.getTagNumber() != TAG_KRB_TGS_REP)
      throw new BadMessageTypeException("Wrong tag for a KrbTGSRep");

    this.rep = new KDCRep(getComponent().encode());
    if (this.rep.getMsgType() != KrbTGSRep.TAG_KRB_TGS_REP)
      throw new BadMessageTypeException("Wrong msgType in KrbASRep");
  }

  /**
   * Returns the KDCRep in this KrbTGSRep
   */ 
  public KDCRep getKDCRep()
  {
    return rep;
  }
}
