//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.v5;

import java.util.Vector;

import com.dstc.security.kerberos.v5.base.*;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Asn1Exception;

/**
 * <p>A class representing the Kerberos ASN.1 structure Krb-TGS-REQ.
 *
 * @version 0.98, 98/11/01
 * @author Ming Yung
 */
public final class KrbTGSReq extends Explicit
{
  public static final int TAG_KRB_TGS_REQ = 12;

  private KDCReq req;

  /**
   * Constructs a KrbTGSReq from a KDCReqBody and a Vector of PaData
   */
  public KrbTGSReq(KDCReqBody reqBody, Vector paDatas)
  {
    super(Asn1.TAG_CLASS_APPLICATION, TAG_KRB_TGS_REQ);

    this.req = new KDCReq(TAG_KRB_TGS_REQ, reqBody, paDatas);
    addComponent(this.req);
  }

  /**
   * Constructs a KrbTGSReq from a DER encoding
   */
  public KrbTGSReq(byte[] encoded) 
    throws Asn1Exception, BadVersionException, BadMessageTypeException 
  {
    doDecode(encoded);

    if (this.getTagNumber() != TAG_KRB_TGS_REQ)
      throw new BadMessageTypeException("Wrong tag for a KrbTGSReq");

    this.req = new KDCReq(getComponent().encode());
    if (this.req.getMsgType() != KrbTGSReq.TAG_KRB_TGS_REQ)
      throw new BadMessageTypeException("Wrong msgType in KrbTGSReq");
  }

  /**
   * Returns the KDCReq in this KrbTGSReq
   */
  public KDCReq getKDCReq()
  {
    return req;
  }
}
