//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.v5;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Asn1Exception;

/**
 * <p>An implementation of the ASN.1 structure PA-DATA.
 *
 * <pre>
 *  PA-DATA ::=  SEQUENCE {
 *                 padata-type[1]        INTEGER,
 *                 padata-value[2]       OCTET STRING,
 *                         -- might be encoded AP-REQ
 *               }
 * </pre>
 * @version 0.98, 98/11/01
 * @author Ming Yung
 */
public final class PaData extends Sequence
{
  private int type;
  private byte[] value;

  /**
   * Constructs a PaData from a type and value
   */
  public PaData(int type, byte[] value)
  {
    this.type = type;
    Explicit exp = new Explicit(Asn1.TAG_CLASS_CONTEXT, 1);
    exp.addComponent(new com.dstc.security.asn1.Integer(type));
    addComponent(exp);

    this.value = value;
    exp = new Explicit(Asn1.TAG_CLASS_CONTEXT, 2);
    exp.addComponent(new OctetString(value));
    addComponent(exp);
  }

  /**
   * Constructs a PaData from a DER encoding
   */
  public PaData(byte[] encoded) throws Asn1Exception
  {
    doDecode(encoded);

    Explicit exp = (Explicit)components.elementAt(0);
    this.type = ((com.dstc.security.asn1.Integer)exp.getComponent()).getInt();

    exp = (Explicit)components.elementAt(1);
    this.value = ((OctetString)exp.getComponent()).getBytes();
  }

  /**
   * Returns the type for this PaData
   */
  public int getType()
  {
    return this.type;
  }

  /**
   * Returns the value for this PaData
   */
  public byte[] getValue()
  {
    return this.value;
  }
}
