//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.v5.base;

import java.util.Vector;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Explicit;


/**
 * <p>A class representing the Kerberos ASN.1 structure HostAddresses.
 *
 * <pre>
 *    HostAddresses ::=  SEQUENCE OF SEQUENCE {
 *                        addr-type[0]             INTEGER,
 *                        address[1]               OCTET STRING
 *                       }
 * </pre>
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class HostAddresses extends Sequence
{
  Vector addresses = new Vector();

  /**
   * Constructs a HostAddresses from a single address
   */
  public HostAddresses(String add) {
    addresses.addElement(new HostAddress(add));
    addComponent(new HostAddress(add));
  }

  /**
   * Constructs a HostAddresses from a Vector of address strings or HostAddress
   */
  public HostAddresses(Vector addrs) {
    for (int i = 0; i < addrs.size(); i++) {
      HostAddress haddr;

      if (addrs.elementAt(i) instanceof HostAddress)
haddr = (HostAddress) addrs.elementAt(i);
      else
haddr = new HostAddress((String) addrs.elementAt(i));

      addresses.addElement(haddr);
      addComponent(haddr);
    }
  }

  /**
   * Constructs a HostAddresses from a DER encoding
   */
  public HostAddresses(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);
    for (int i=0; i<components.size(); i++)
    {
      addresses.addElement(new 
        HostAddress(((Asn1)components.elementAt(i)).encode()));
    }
  }

  /**
   * Returns the Vector of HostAddress for this HostAddresses
   */
  public Vector getAddresses()
  {
    return addresses;
  }
}
