//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.v5.base;

import java.util.Vector;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Explicit;

/**
 * <p>A class representing the Kerberos ASN.1 structure LastReq.
 *
 * <pre>
 * LastReq ::=  SEQUENCE OF SEQUENCE {
 *                     lr-type[0]     INTEGER,
 *                     lr-value[1]    KerberosTime
 * }
 * </pre>
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class LastReq extends Sequence
{
  Vector req = new Vector();

  /**
   * Constructs a LastReq from a DER encoding
   */
  public LastReq(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);
    
    for (int i=0; i<components.size(); i++)
    {
      req.addElement((Sequence)components.elementAt(i));
    }
  }

  /**
   * <p>Inner class representing the inner SEQUENCE of LastReq
   */
  protected class ILastReq extends Sequence
  {
    private int type;
    private KerberosTime value;

    protected ILastReq(byte encoded[]) throws Asn1Exception
    {
      doDecode(encoded);

      Explicit exp = (Explicit)components.elementAt(0);
      this.type = ((com.dstc.security.asn1.Integer)exp.getComponent()).getInt();

      exp = (Explicit)components.elementAt(1);
      this.value = new KerberosTime(exp.getComponent().encode());
    }
  }
}
