//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.kerberos.v5.crypto;

import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;

/** 
 * <p> Class representing the Kerberos ASN.1 structure EncryptionKey.
 *
 * <pre>
 * EncryptionKey ::= SEQUENCE {
 *                     keytype[0]  INTEGER,
 *                     keyvalue[1] OCTET STRING
 * }
 * </pre>
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class EncryptionKey extends Sequence
{
  private int keyType;
  private byte[] keyValue;

  /**
   * Constructs an EncryptionKey from a key type and key bytes
   */
  public EncryptionKey(int keyType, byte keyValue[])
  {
    this.keyType = keyType;
    Explicit exp = new Explicit(Asn1.TAG_CLASS_CONTEXT, 0);
    exp.addComponent(new com.dstc.security.asn1.Integer(keyType));
    addComponent(exp);

    this.keyValue = keyValue;
    exp = new Explicit(Asn1.TAG_CLASS_CONTEXT, 1);
    exp.addComponent(new OctetString(keyValue));
    addComponent(exp);
  }

  /**
   * Constructs an EncryptionKey from a DER encoding
   */
  public EncryptionKey(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);

    Explicit exp = (Explicit)components.elementAt(0);
    if (exp.getTagNumber() != 0)
      throw new Asn1Exception("Bad Tag number");
    this.keyType 
      = ((com.dstc.security.asn1.Integer)exp.getComponent()).getInt();

    exp = (Explicit)components.elementAt(1);
    if (exp.getTagNumber() != 1)
      throw new Asn1Exception("Bad Tag number");
    this.keyValue = ((OctetString)exp.getComponent()).getBytes();
  }

  /**
   * Returns the key bytes
   */
  public byte[] getKeyBytes()
  {
    return this.keyValue;
  }

  /**
   * Returns the key type
   */
  public int getKeyType()
  {
    return this.keyType;
  }
}
