//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.pki.netscape;

import com.dstc.security.x509.SubjectPublicKeyInfo;
import com.dstc.security.pki.CertificationRequest;
import com.dstc.security.asn1.Asn1Exception;

/**
 * <p>A class representing a NetscapeCertificationRequest sent from
 * a Netscape browser upon generation of a public key pair
 *
 * @version 0.98, 98/11/01
 * @author Ming Yung
 */
public class NetscapeCertificationRequest implements CertificationRequest
{
  private SignedPubKeyAndChallenge spkc;

  /**
   * Constructs a NetscapeCertificationRequest froma  Asn1 encoding
   */
  public NetscapeCertificationRequest(byte[] encoded) throws Asn1Exception
  {
    spkc = new SignedPubKeyAndChallenge(encoded);
  }

  /**
   * Returns the SubjectPublicKeyInfo for this NetscapeCertificationRequest
   */
  public SubjectPublicKeyInfo getSubjectPublicKeyInfo()
  {
    return spkc.getSubjectPublicKeyInfo();
  }

  /**
   * Returns the signature for this NetscapeCertificationRequest
   */
  public byte[] getSignature()
  {
    return spkc.getSignature();
  }

  /**
   * Returns the signature algorithm name for this NetscapeCertificationRequest
   */
  public String getSigAlgName()
  {
    return spkc.getSigAlgName();
  }

  /**
   * Returns the subject name for this NetscapeCertificationRequest
   * ie. null
   */
  public String getSubjectName()
  {
    return null;
  }

  /**
   * Returns the key algorithm name for this NetscapeCertificationRequest
   */
  public String getKeyAlgName()
  {
    return spkc.getKeyAlgName();
  }

  /**
   * Verifies the signature in this CertificationRequest
   */
  public boolean verifySignature()
  {
    return spkc.verifySignature();
  }
}
