//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.pki.pkcs10;

import com.dstc.security.x509.SubjectPublicKeyInfo;
import com.dstc.security.asn1.Asn1Exception;

/**
 * Implementation of CertficateRequest for PKCS10
 *
 * @version 0.98 98/07/07
 * @author Ming Yung
 */
public class PKCS10CertificationRequest 
  implements com.dstc.security.pki.CertificationRequest
{
  private CertificationRequest certReq;

  /**
   * Constructs a PKCS10CertificationRequest from a DER encoding
   */
  public PKCS10CertificationRequest(byte[] encoded) throws Asn1Exception
  {
    certReq = new CertificationRequest(encoded);
  }

  /**
   * Returns the SubjectPublicKeyInfo for this PKCS10CertificationRequest
   */
  public SubjectPublicKeyInfo getSubjectPublicKeyInfo()
  {
    return certReq.getCertificationRequestInfo().getSubjectPublicKeyInfo();
  }

  /**
   * Returns the signature for this PKCS10CertificationRequest
   */
  public byte[] getSignature()
  {
    return certReq.getSignature();
  }

  /**
   * Returns the signature algorithm name for this PKCS10CertificationRequest
   */
  public String getSigAlgName()
  {
    return certReq.getSigAlgName();
  }

  /**
   * Returns the key algorithm name for this PKCS10CertificationRequest
   */
  public String getKeyAlgName()
  {
    return certReq.getCertificationRequestInfo().getKeyAlgName();
  }

  /**
   * Returns the subject name for this PKCS10CertificationRequest
   */
  public String getSubjectName()
  {
    return certReq.getCertificationRequestInfo().getSubject().getName();
  }

  /**
   * Verifies the signature in this CertificationRequest
   */
  public boolean verifySignature()
  {
    return certReq.verifySignature();
  }

  /**
   * Returns the CertificationRequestInfo in this CertificationRequest
   */
  public CertificationRequestInfo getCertificationRequestInfo()
  {
    return certReq.getCertificationRequestInfo();
  }
}
