//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.provider;

import javax.crypto.SecretKey;
import java.security.InvalidKeyException;
import java.security.spec.KeySpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.spec.SecretKeySpec;
import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKeyFactorySpi;

/**
 * <p>Implements a Factory class for secret keys to use with the 
 * Blowfish cipher.
 *
 * @see javax.crypto.SecretKeyFactory
 * @see com.dstc.security.provider.BlowfishSecretKey
 * @see com.dstc.security.provider.Blowfish
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class BlowfishSecretKeyFactory extends SecretKeyFactorySpi
{
  protected SecretKey engineGenerateSecret(KeySpec keySpec) 
    throws InvalidKeySpecException
  {
    if (keySpec instanceof SecretKeySpec)
    {
      if (!((SecretKeySpec)keySpec).getAlgorithm().equals("Blowfish"))
        throw new InvalidKeySpecException("Not a Blowfish key spec");

      return new BlowfishSecretKey(((SecretKeySpec)keySpec).getEncoded());
    }

    throw new InvalidKeySpecException("Not a Blowfish key spec");
  }

  protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) 
    throws InvalidKeySpecException
  {
    throw new InvalidKeySpecException("No Blowfish-specific keyspec supported");
  }

  protected SecretKey engineTranslateKey(SecretKey key) 
    throws InvalidKeyException
  {
    if (key instanceof SecretKeySpec)
      return new BlowfishSecretKey(key.getEncoded()); 

    if (key instanceof BlowfishSecretKey)
      return new SecretKeySpec(key.getEncoded(), "Blowfish");

    throw new InvalidKeyException("Cannot translate this key");
  }
}
