//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.provider;

//From JDK
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.io.IOException;
//From JCSI
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.x509.AlgorithmId;

/**
 * <p>Implements algorithm parameters for the DH Based Parameter
 * 
 * @see java.security.AlgorithmParameters
 *
 * @version 0.98, 99 July 5
 * @author Eddy Cheung
 * @author Ming Yung
 */
public final class DHBMParameters extends AlgorithmParametersSpi
{
  private DHBMParameterSpec paramsSpec;
  private DHBMParams params;

  protected void engineInit(AlgorithmParameterSpec paramSpec) 
    throws InvalidParameterSpecException
  {
    if (!(paramSpec instanceof DHBMParameterSpec))
      throw new InvalidParameterSpecException("Not a PBM param spec");

    this.paramsSpec = (DHBMParameterSpec)paramSpec;
    this.params = new DHBMParams(paramsSpec.getOwfAlgorithmId(),
                                paramsSpec.getMacAlgorithmId());
  }

  protected void engineInit(byte[] params) throws IOException
  {
    try
    {
      this.params = new DHBMParams(params);
      this.paramsSpec = new DHBMParameterSpec(this.params.owf_id,
                                             this.params.mac_id);
    }
    catch (Exception e)
    {
      throw new IOException(e.toString());
    }
  }

  protected void engineInit(byte[] params, String format) throws IOException
  {
    engineInit(params);
  }

  protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) 
    throws InvalidParameterSpecException
  {
    if (!paramSpec.getName().equals("com.dstc.security.provider.DHBMParameterSpec"))
      throw new InvalidParameterSpecException(paramSpec.getName() +
        " not supported");

    return this.paramsSpec;
  }

  protected byte[] engineGetEncoded() throws IOException
  {
    return params.encode();
  }

  protected byte[] engineGetEncoded(String format) throws IOException
  {
    return engineGetEncoded();
  }

  protected String engineToString()
  {
    return "DHBM Parameters";
  }

  /**
   * <p>Inner class representing the ASN.1 structure DHBMParameters
   *
   * <p>DHBMParameter ::= SEQUENCE {
   *       owf               AlgorithmIdentifier,
   *       --AlgId for a One-Way Function (SHA-1 recommended)
   *       iterationCount    INTEGER,
   *       --Number of times the OWF is applied
   *       mac               AlgorithmIdentifier
   *       -- the MAC AlgId (e.g., DES-MAC, Triple_DES_MAC [PKCS11],
   *       -- or HMAC [RFC2104, RFC2202]
   *    }
   */
  protected class DHBMParams extends Sequence
  {
      private AlgorithmId owf_id;
      private AlgorithmId mac_id;
  
    /**
     * Constructs a DHBMParams given parameters owf, and a mac algorithmId
     */
    protected DHBMParams (AlgorithmId owf, AlgorithmId mac) 
    {
this.owf_id = owf;
this.addComponent(owf);

this.mac_id = mac;
this.addComponent(mac);
    }
  
    /**
     * Constructs a DHBMParams from a DER encoding
     */
    protected DHBMParams(byte encoded[]) throws Asn1Exception
    {
      doDecode(encoded);

      int i = 0;

      this.owf_id = new AlgorithmId(((Asn1)components.elementAt(i++)).encode());

      this.mac_id = new AlgorithmId(((Asn1)components.elementAt(i++)).encode());

    }
  }
}
