//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.provider;

import java.math.BigInteger;
import javax.crypto.spec.DHParameterSpec;
import java.security.AlgorithmParameters;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.x509.SubjectPublicKeyInfo;

/**
 * <p>Implements a public key for use with the Diffie-Hellman key agreement
 * algorithm.
 * 
 * @see java.security.PublicKey
 * @see java.security.DHKeyAgreement
 * @see com.dstc.security.provider.DHParameters
 * @see com.dstc.security.provider.DHPrivateKey
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public class DHPublicKey extends com.dstc.security.asn1.Integer
  implements javax.crypto.interfaces.DHPublicKey
{
  private BigInteger y;
  private DHParameterSpec params;

  protected DHPublicKey(BigInteger y, BigInteger p, BigInteger g, int l)
  {
    super(y);
    this.y = y;
    this.params = new DHParameterSpec(p, g, l);
  }

  public BigInteger getY()
  {
    return this.y;
  }

  public DHParameterSpec getParams()
  {
    return this.params;
  }

  public String getAlgorithm()
  {
    return "DH";
  }

  public String getFormat()
  {
    return "X.509";
  }

  ///Returns DER encoding of SubjectPublicKeyInfo for this key
  public byte[] getEncoded()
  {
    try
    {
      AlgorithmParameters algParams =
        AlgorithmParameters.getInstance("DH", "DSTC");
      algParams.init(params);

      return new SubjectPublicKeyInfo(
        new AlgorithmId(OID.dhKeyAgreement, algParams),
        super.encode()).encode();
    }
    catch (Exception e)
    {
      System.out.println(e.toString());
      return null;
    }
  }

  //Constructs a DH public key from a DER INTEGER encoding and DHParams
  protected DHPublicKey(byte encoded[], DHParameterSpec params)
    throws Asn1Exception
  {
    doDecode(encoded);
    this.y = this.getBigInteger();
    this.params = params;
  }
}
