//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.provider;

import java.util.*;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Random;
import java.security.SignatureSpi;
import java.security.PublicKey;
import java.security.PrivateKey;
import java.security.MessageDigest;
import java.security.KeyFactory;
import java.security.InvalidParameterException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Mac;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.x509.Attribute;
import com.dstc.security.cms.atts.*;

/**
 * <p>Implements the Diffie-Hellman (DH) signing algorithm for
 * proof-of-possession of Diffie-Hellman private keys.
 *
 * NB: to be used in Diffie-Hellman certification requests.
 *
 * @see java.security.Signature
 * @see com.dstc.security.provider.DSAParameters
 * @see com.dstc.security.provider.DSAPublicKey
 * @see com.dstc.security.provider.DSAPrivateKey
 *
 * @version 0.98, 99/02/09
 * @author Nishanth Chandran
 * @author Ming Yung
 */

public abstract class DHSignature extends SignatureSpi 
{
  protected DHParameterSpec dhParamSpec;
  protected DHPublicKey dhPubKey;    
  protected DHPrivateKey dhPvtKey;
  protected DHPrivateKey CAPvt;
  protected DHPublicKey CAPub;
  protected byte[] text;
  protected ByteArrayOutputStream bos;
  protected KeyAgreement keyAgree;
  protected BigInteger p,g;
  protected int l;

  protected void engineSetParameters(String param, Object value)
  {
    //Deprecated . Does nothing
  }

  protected Object engineGetParameter(String param)
    throws InvalidParameterException 
  {
    //Deprecated
    return null;
  }
 
  protected void engineSetParameter(String param, Object value)
  {
    //deprecated 
  }   
 
  //Updates buffer with a byte
  protected void engineUpdate(byte b) throws SignatureException
  {
    byte[] temp = {b};
    engineUpdate(temp,0,1);
  }

  //Updates buffer with a byte array
  protected void engineUpdate(byte b[], int off, int len)
    throws SignatureException
  {
    bos.write(b,off,len);
  }

  protected byte[] computeSign() throws SignatureException
  {
    try 
    {
      byte[] sharedSecret = keyAgree.generateSecret();
 
      byte[] leadingInfo = new com.dstc.security.asn1.Integer(p).encode();
      byte[] trailingInfo = new com.dstc.security.asn1.Integer(g).encode();

      MessageDigest sha1 = MessageDigest.getInstance("SHA");
      sha1.update(leadingInfo);
      sha1.update(sharedSecret);
      sha1.update(trailingInfo);
 
      SecretKeySpec secretKeySpec = new SecretKeySpec(sha1.digest(), "DH");
      Mac mac = Mac.getInstance("HMACwithSHA1","DSTC");
      mac.init(secretKeySpec, dhParamSpec);
      mac.update(text);
 
      byte[] hashValue = mac.doFinal();
 
      return hashValue;
    }
    catch(Exception e)
    {
      e.printStackTrace();
      throw new SignatureException(e.getMessage());
    }  
  }
}
