//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.provider;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.AlgorithmParameters;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.PBEParameterSpec;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.pkcs8.PrivateKeyInfo;
import com.dstc.security.pkcs8.EncryptedPrivateKeyInfo;

/**
 * <p>Implements a private key for use with the DSA signature algorithm.
 * 
 * @see java.security.PublicKey
 * @see java.security.DSA
 * @see com.dstc.security.provider.DSAParameters
 * @see com.dstc.security.provider.DSAPublicKey
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
//public class DSAPrivateKey extends com.dstc.security.asn1.Integer
public class DSAPrivateKey extends Sequence
  implements PrivateKey, java.security.interfaces.DSAPrivateKey
{
  private BigInteger x;
  private DSAParameterSpec dsaParamsSpec;

  //Constructs a DSAPrivateKey given value x and DSAParams
  protected DSAPrivateKey(BigInteger x, DSAParameterSpec dsaParamsSpec) 
  {
    //super(x);
    this.x = x;
    this.dsaParamsSpec = dsaParamsSpec;
  }

  ///Returns algorithm "DSA"
  public String getAlgorithm() 
  {
    return "DSA";
  }

  ///Returns format "PKCS#8"
  public String getFormat() 
  {
    return "PKCS#8";
  }

  ///Returns value x
  public BigInteger getX() 
  {
    return x;
  }

  ///Returns DSAParams for this key
  public DSAParams getParams() 
  {
    return dsaParamsSpec;
  }

  ///Returns DER encoding of PrivateKeyInfo for this key
  public byte[] getEncoded()
  {
    try
    {
      AlgorithmParameters algParams =
        AlgorithmParameters.getInstance("DSA", "DSTC");
      algParams.init(dsaParamsSpec);

      //Get Encoded private key
      byte priv[] = (new PrivateKeyInfo(new AlgorithmId(OID.dsa,
        //algParams), super.encode())).encode();
        algParams), (new com.dstc.security.asn1.Integer(this.x)).encode())
          ).encode();

      return priv;
    }
    catch (Exception e)
    {
      System.out.println(e.toString());
      return null;
    }
  }

  //Constructs a DSA private key from a DER INTEGER encoding and DSAParams
  public DSAPrivateKey(byte encoded[], DSAParameterSpec dsaParamsSpec)
    throws Asn1Exception
  {
    //doDecode(encoded);
    //this.x = this.getBigInteger();
    com.dstc.security.asn1.Integer asn1Int
     = (com.dstc.security.asn1.Integer)Asn1.decode(encoded);
    this.x = asn1Int.getBigInteger();
    this.dsaParamsSpec = dsaParamsSpec;
  }
}
