//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.provider;

import java.util.Properties;

/**
 * <p>A class which centralizes the management of Algorithm Object
 * Identifiers.
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public class OID 
{
  // Message Digest Algorithms
  public static final String md2 = "1.2.840.113549.2.2";
  public static final String md5 = "1.2.840.113549.2.5";
  public static final String sha_1 = "1.3.14.3.2.26";
  public static final String ripemd_160 = "1.3.36.3.2.1";
  
  // Signature Algorithms
  //public static final String dsaWithSHA = "1.3.14.3.2.13";
  public static final String dsaWithSHA = "1.2.840.10040.4.3";
  public static final String md2WithRSAEncryption = "1.2.840.113549.1.1.2";
  public static final String md5WithRSAEncryption = "1.2.840.113549.1.1.4";
  public static final String sha_1WithRSAEncryption = "1.3.14.3.2.29";
  public static final String dhe = "1.0.1.0.1.0"; //unassigned
  
  //Password-Based Cipher - PKCS#5 
  public static final String pbeWithMD2AndDES_CBC = "1.2.840.113549.1.5.1";
  public static final String pbeWithMD5AndDES_CBC = "1.2.840.113549.1.5.3";    
  // Public Key Algorithms
  public static final String rsaEncryption = "1.2.840.113549.1.1.1";
  //public static final String dsa = "1.3.14.3.2.12";
  public static final String dsa = "1.2.840.10040.4.1";
  public static final String dhpublicnumber = "1.2.840.10046.2.1";
  public static final String dhKeyAgreement = "1.2.840.113549.1.3.1";
  
  // Symmetric Key Algorithms
  public static final String rc2_cbc = "1.2.840.113549.3.2";
  public static final String des_ede3_cbc = "1.2.840.113549.3.7";
  
  // From X.500
  public static final String country = "2.5.4.6";
  public static final String locality = "2.5.4.7";
  public static final String state = "2.5.4.8";
  public static final String organization = "2.5.4.10";
  public static final String organizationalUnit = "2.5.4.11";
  public static final String commonName = "2.5.4.3";
  public static final String emailAddress = "1.2.840.113549.1.9.1";
  
  // X.509 Extensions
  public static final String subjectKeyIdentifier = "2.5.29.14";
  public static final String keyUsage = "2.5.29.15";
  public static final String subjectAltName = "2.5.29.17";
  public static final String issuerAltName = "2.5.29.18";
  public static final String basicConstraints = "2.5.29.19";
  public static final String authorityKeyIdentifier = "2.5.29.35";
  public static final String netscapeCertType = "2.16.840.1.113730.1.1";
  
  // S/MIME
  public static final String id_data = "1.2.840.113549.1.7.1";
  public static final String id_signedData = "1.2.840.113549.1.7.2";
  public static final String id_envelopedData = "1.2.840.113549.1.7.3";
  public static final String id_digestedData = "1.2.840.113549.1.7.5";
  public static final String id_encryptedData = "1.2.840.113549.1.7.6";
  public static final String id_authData = "1.2.840.113549.1.9.16.1.2";
  
  public static final String id_contentType = "1.2.840.113549.1.9.3";
  public static final String id_messageDigest = "1.2.840.113549.1.9.4";
  public static final String id_signingTime = "1.2.840.113549.1.9.5";
  public static final String id_counterSignature= "1.2.840.113549.1.9.6";
  public static final String id_macValue = "1.2.840.113549.1.9.16.2.8";
  public static final String smimeCapabilities = "1.2.840.113549.1.9.15";

  //CMP 
  public static final String PasswordBasedMac = "1.2.840.113533.7.66.13";
  public static final String DHBasedMac = "1.2.840.113533.7.66.30";

  // PKCS#12
  public static final String pbeWithSHAAnd128BitRC4 
    = "1.2.840.113549.1.12.1.1";
  public static final String pbeWithSHAAnd40BitRC4 
    = "1.2.840.113549.1.12.1.2";
  public static final String pbeWithSHAAnd3_KeyTripleDES_CBC 
    = "1.2.840.113549.1.12.1.3";
  public static final String pbeWithSHAAnd2_KeyTripleDES_CBC 
    = "1.2.840.113549.1.12.1.4";
  public static final String pbeWithSHAAnd128BitRC2_CBC 
    = "1.2.840.113549.1.12.1.5";
  public static final String pbeWithSHAAnd40BitRC2_CBC 
    = "1.2.840.113549.1.12.1.6";

  // pkcs-12BagIds
  public static final String id_bagTypes = "1.2.840.113549.1.12.10.1";
  public static final String keyBag = "1.2.840.113549.1.12.10.1.1";
  public static final String pkcs_8ShroudedKeyBag 
    = "1.2.840.113549.1.12.10.1.2";
  public static final String certBag = "1.2.840.113549.1.12.10.1.3";
  public static final String crlBag = "1.2.840.113549.1.12.10.1.4";
  public static final String secretBag = "1.2.840.113549.1.12.10.1.5";
  public static final String safeContentBag = "1.2.840.113549.1.12.10.1.6";
  
  //PKCS#12 induced OID to be included in PKCS#9
  public static final String friendlyName = "1.2.840.113549.1.9.20";
  public static final String localKeyId = "1.2.840.113549.1.9.21";
  public static final String id_certTypes = "1.2.840.113549.1.9.22";
  public static final String x509Certificate = "1.2.840.113549.1.9.22.1";
  public static final String sdsiCertificate = "1.2.840.113549.1.9.22.2";
  public static final String id_crlTypes = "1.2.840.113549.1.9.23";
  public static final String x509crl = "1.2.840.113549.1.0.23.1";

  private static Properties names;
  private static Properties oids;
  
  public OID () {}
  
  static
  {
    names = new Properties ();

    names.put(md2, "MD2");
    names.put(md5, "MD5");
    names.put(sha_1, "SHA");
    names.put(ripemd_160, "RIPEMD-160");

    names.put(dsaWithSHA, "SHA1withDSA");
    names.put(md2WithRSAEncryption, "MD2withRSA");
    names.put(md5WithRSAEncryption, "MD5withRSA");
    names.put(sha_1WithRSAEncryption, "SHA1withRSA");
    names.put(dhe, "DH");

    names.put(dsa, "DSA");
    names.put(rsaEncryption, "RSA");

    names.put(rc2_cbc, "RC2/CBC");
    names.put(des_ede3_cbc, "DESede/CBC");

    names.put(pbeWithMD5AndDES_CBC, "PBEwithMD5andDES-CBC");
    names.put(pbeWithMD2AndDES_CBC, "PBEwithMD2andDES-CBC");
    names.put(pbeWithSHAAnd3_KeyTripleDES_CBC, 
              "PBEwithSHAand3-KeyTripleDES-CBC");
    names.put(pbeWithSHAAnd40BitRC2_CBC, "PBEwithSHAand40BitRC2-CBC");
     
    names.put(dhKeyAgreement, "DH");

    names.put(country, "C");
    names.put(state, "ST");
    names.put(locality, "L");
    names.put(organization, "O");
    names.put(organizationalUnit, "OU");
    names.put(commonName, "CN");
    names.put(emailAddress, "EmailAddress");

    names.put(id_data, "id-data");
    names.put(id_signedData, "id-signedData");
    names.put(id_envelopedData, "id-envelopedData");
    names.put(id_contentType, "id-contentType");
    names.put(id_messageDigest, "id-messageDigest");
    names.put(id_signingTime, "id-signingTime");

    //CMP stuff
    names.put(PasswordBasedMac, "PasswordBasedMac");
    names.put(DHBasedMac, "DHBasedMac");

    ////////////////////////////////////////////////////////// 

    oids = new Properties();

    oids.put("SHA/DSA", dsaWithSHA);
    oids.put("SHA1withDSA", dsaWithSHA);
    oids.put("SHA-1/DSA", dsaWithSHA);
    oids.put("SHA1withRSA", sha_1WithRSAEncryption);
    oids.put("SHA-1/RSA", sha_1WithRSAEncryption);
    oids.put("MD5withRSA", md5WithRSAEncryption);
    oids.put("MD5/RSA", md5WithRSAEncryption);
    oids.put("MD2/RSA", md2WithRSAEncryption);

    oids.put("DSA", dsa);
    oids.put("RSA", rsaEncryption);
 
    oids.put("SHA", sha_1);
    oids.put("SHA-1", sha_1);
    oids.put("MD5", md5);

    oids.put("C", country);
    oids.put("ST", state);
    oids.put("L", locality);
    oids.put("O", organization);
    oids.put("OU", organizationalUnit);
    oids.put("CN", commonName);
    oids.put("EmailAddress", emailAddress);

    oids.put("id-data", id_data);
    oids.put("id-signedData", id_signedData);
    oids.put("id-envelopedData", id_envelopedData);
    oids.put("id-contentType", id_contentType);
    oids.put("id-messageDigest", id_messageDigest);
    oids.put("id-signingTime", id_signingTime);
  }
  
  public static final String getAlgName(String oid)
  {
    return (String)names.get(oid);
  }
  
  public static final String getAlgOid(String name)
  {
    return (String)oids.get(name);
  }
}
