//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.provider;

import java.security.PublicKey;
import java.math.BigInteger;
import java.util.Vector;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.x509.SubjectPublicKeyInfo;

/**
 * <p>Implements a public key for use with the RSA-based signature algorithms.
 * 
 * @see java.security.PublicKey
 * @see java.security.RSAwithAnyMD
 * @see com.dstc.security.provider.RSAParameters
 * @see com.dstc.security.provider.RSAPrivateKey
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public class RSAPublicKey extends Sequence
  implements PublicKey, java.security.interfaces.RSAPublicKey
{
  private BigInteger modulus, exponent;

  //Constructs a key from a modulus and exponent
  protected RSAPublicKey (BigInteger modulus, BigInteger exponent) 
  {
    super();
    this.modulus = modulus;
    this.exponent = exponent;
    this.addComponent(new com.dstc.security.asn1.Integer(modulus));
    this.addComponent(new com.dstc.security.asn1.Integer(exponent));
  }

  ///Returns the algorithm "RSA"
  public String getAlgorithm () 
  {
    return "RSA";
  }

  ///Returns the format "X.509"
  public String getFormat () 
  {
    return "X.509";
  }

  ///Returns the modulus for this key
  public BigInteger getModulus () 
  {
    return modulus;
  }

  ///Returns the exponent for this key
  public BigInteger getPublicExponent () 
  {
    return exponent;
  }

  ///Returns the DER encoding of SubjectPublickeyInfo for this key
  public byte[] getEncoded () 
  {
    try
    {
      return (new SubjectPublicKeyInfo(new AlgorithmId(OID.rsaEncryption, 
       null), super.encode())).encode();
    }
    catch (Exception e)
    {
      System.out.println(e.toString());
      return null;
    }
  }

  /**
   * Constructs a public key from a DER encoding
   *     SEQUENCE { INTEGER, INTEGER } for this key
   */
  protected RSAPublicKey(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);
    this.modulus = ((com.dstc.security.asn1.Integer)components.
                     elementAt(0)).getBigInteger();
    this.exponent = ((com.dstc.security.asn1.Integer)components.
                     elementAt(1)).getBigInteger();
  }
}
