//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.smime.handlers;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.util.Vector;

import javax.activation.DataSource;
import javax.activation.DataContentHandler;
import javax.mail.MessagingException;

import com.dstc.security.smime.SMIMEPart;
import com.dstc.security.cms.EnvelopedMessage;

/**
 * <p>An implementation of a DataContentHandler for content-type
 * x_pkcs_7_mime.
 *
 * @version 0.98, 98/11/01
 * @author Ming Yung
 */
public class x_pkcs7_mime implements DataContentHandler
{
  /**
   * Returns an SMIMEPart from a DataSource or null if there is none
   */
  public Object getContent(DataSource dataSource)
  {
    try
    {
      BufferedInputStream dis
        = new BufferedInputStream(dataSource.getInputStream());
      byte encoded[] = new byte[dis.available()];
      dis.read(encoded);

      EnvelopedMessage envMessage = new EnvelopedMessage(encoded);
      return envMessage;
    }
    catch (Exception e)
    {
      e.printStackTrace();
      return null;
    }
  }

  /**
   * Writes an SMIMEPart object to the OutputStream
   */
  public void writeTo(Object obj, String str, OutputStream os)
    throws IOException
  {
    if ((obj instanceof EnvelopedMessage) &&
         str.startsWith("application/x-pkcs7-mime"))
    {
      byte[] retval = ((EnvelopedMessage)obj).getEncoded();
      os.write(retval);
    }
  }

  public Object getTransferData(DataFlavor flavor, 
                                DataSource dataSource)
  {
    return null;
  }

  public DataFlavor[] getTransferDataFlavors()
  {
    return null;
  }
}
