//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;
import java.io.ByteArrayInputStream;

/**
 * Class for the Application Data messages
 *
 * @author Ming Yung
 */
final class ApplicationData extends V3Message
{
  /**
   * Default constructor for an ApplicationData message
   */
  protected ApplicationData()
  {
    this.contentType = SSLProtocolUnit.APPLICATION_DATA;
  }
    
  /**
   * Constructs an ApplicationData message from an XDRInputStream
   */
  protected ApplicationData(byte[] data) throws IOException
  {
    this(data, 0, data.length);
  }

  protected ApplicationData(byte[] data, int offset, int length) 
    throws IOException
  {
    this();

    this.length = length;
    this.data = new byte[length];
    System.arraycopy(data, offset, this.data, 0, length);

    if (Debug.debug >= Debug.DEBUG_MSG)
      Debug.debug("<> ApplicationData");
  }

  /**
   * Writes the data in this message to the XDROutputStream
   */
  protected void write(XDROutputStream os) throws IOException
  {
    os.write(this.data);
  }

  /**
   * Returns the data in this message
   */
  public byte[] getBytes() throws IOException
  {
    return this.data;
  }
}
