//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.util.Vector;
import java.net.ServerSocket;
import java.net.InetAddress;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLKeyException;

/**
 * An abstract SSLServerSocketFactory which does not require the use of
 * properties files for configuration.
 *
 * Subclassed by SSLServerSocketFactory which does require properties for
 * configuration.
 *
 * @author Ming Yung
 */
public abstract class BaseSSLServerSocketFactory 
  extends javax.net.ssl.SSLServerSocketFactory
{
  //per factory objects
  protected static BaseSSLServerSocketFactory instance = null;
  private SecureRandom rand = null;
  private Vector trustedCerts = null;
  private SessionCache cache = null;

  //per serversocket objects
  private PrivateKey privKey = null;
  private Vector serverCerts = null;
  private String[] enabledCipherSuites = null;
  private boolean clientAuthRequired = false;

  protected BaseSSLServerSocketFactory() throws SSLKeyException
  {
    super();

    // Only for testing (to speed up seeding, at the expense of security!!!) 
    this.rand = new SecureRandom(new byte[8]);
    this.cache = new SessionCache();
  }

  public String[] getDefaultCipherSuites()
  {
    return this.enabledCipherSuites;
  }

  public String[] getSupportedCipherSuites()
  {
    return CipherSuites.suiteName;
  }

  public ServerSocket createServerSocket(int port)
    throws IOException
  {
    return new SSLServerSocket(this, port, privKey, serverCerts, 
                               clientAuthRequired, enabledCipherSuites);
  }

  public ServerSocket createServerSocket(int port, int backlog)
    throws IOException
  {
    return new SSLServerSocket(this, port, backlog, privKey, serverCerts,
                               clientAuthRequired, enabledCipherSuites);
  }

  public ServerSocket createServerSocket(int port, int backlog,
                                         InetAddress ifAddress)
    throws IOException
  {
    return new SSLServerSocket(this, port, backlog, ifAddress, privKey, 
                               serverCerts, clientAuthRequired, 
                               enabledCipherSuites);
  }

  ////////////////////////////////////////////////////////////////
  // Methods not defined in javax.net.ssl.SSLServerSocketFactory
  ////////////////////////////////////////////////////////////////

  protected void initializeKeys() throws SSLKeyException {}

  public void setDefaultCipherSuites(String[] suites)
  {
    this.enabledCipherSuites = suites;
  }

  public void setClientAuthRequired(boolean truth)
  {
    this.clientAuthRequired = truth;
  }

  public void setServerPrivateKey(PrivateKey priv)
  {
    this.privKey = priv;
  }

  public void setServerCertificates(Vector certs)
  {
    this.serverCerts = certs;
  }

  public void setTrustedCertificates(Vector certs)
  {
    this.trustedCerts = certs;
  }

  Vector getTrustedCertificates()
  {
    return this.trustedCerts;
  }

  SessionCache getSessionCache()
  {
    return this.cache;
  }

  SecureRandom getRandom()
  {
    return this.rand;
  }
}
