//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;
import java.util.Vector;

import javax.net.ssl.SSLException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLHandshakeException;

/**
 * A class for Certificate Handshake messages sent by either a server
 * or client for authentication.
 *
 * @author Ming Yung
 */
final class Certificate extends HandShake
{
  private byte[] encCerts;

  /**
   * Constructs a Certificate message from an XDRInputStream with
   * a callback to the controlling HandShaker
   */
  protected Certificate(HandShaker handShaker, byte[] data) 
    throws IOException
  {
    super(handShaker, data);

    if (Debug.debug >= Debug.DEBUG_MSG)
      Debug.debug("++ Certificate");
  }

  /**
   * Constructs a Certificate message from a Vector of X509Certificates
   * with a callback to the controlling HandShaker
   *
   * <p>The server certificate must be the first element of the Vector
   */
  protected Certificate(HandShaker handShaker, Vector certs) 
    throws IOException
  {
    this.handShaker = handShaker;
    this.msgType = CERTIFICATE;

    this.encCerts = this.handShaker.processSenderCerts(certs);

    this.bodyLength = 3 + this.encCerts.length;
  }

  /**
   * Reads the body of this Certificate message from an XDRInputStream
   */
  protected void readBody(XDRInputStream is) 
    throws IOException
  {
    this.encCerts = is.readVector(3);
    this.handShaker.processReceivedCerts(this.encCerts);
  }

  /**
   * Writes the body of this Certificate message to an XDROutputStream
   */
  protected void writeBody(XDROutputStream os) throws IOException
  {
    os.writeVector(3, encCerts);
  }
}
