//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.util.Vector;
import java.io.IOException;

import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

/**
 * A class for CertificateRequest Handshake messages sent by a server
 * to a client
 *
 * @author Ming Yung
 */
final class CertificateRequest extends HandShake
{
  protected static final byte RSA_SIGN = 0x01;
  protected static final byte DSS_SIGN = 0x02;
  protected static final byte RSA_FIXED_DH = 0x03;
  protected static final byte DSS_FIXED_DH = 0x04;
  protected static final byte RSA_EPHEMERAL_DH = 0x05;
  protected static final byte DSS_EPHEMERAL_DH = 0x06;
  protected static final byte FORTEZZA_KEA = 0x07;

  private byte[] certTypes;
  private byte[] cas;

  /**
   * Constructs a CertificateRequest message from an XDRInputStream with
   * a callback to the controlling HandShaker
   */
  protected CertificateRequest(ClientHandShaker handShaker, byte[] data) 
    throws IOException
  {
    super(handShaker, data);

    if (Debug.debug >= Debug.DEBUG_MSG)
      Debug.debug("++ CertificateRequest");
  }

  /**
   * Constructs a CertificateRequest message from with a
   * callback to the controlling ServerHandShaker
   */
  protected CertificateRequest(ServerHandShaker handShaker, 
                            byte[] certTypes, Vector cAs)
    throws IOException
  {
    this.handShaker = handShaker;
    this.msgType = CERTIFICATE_REQUEST;
    this.certTypes = certTypes;

    this.cas = handShaker.processAcceptableCAs(cAs);

    this.bodyLength = 3 + this.certTypes.length + this.cas.length;
  }

  /**
   * Reads the body of this CertificateRequest message from an XDRInputStream
   */
  protected void readBody(XDRInputStream is) 
    throws IOException
  {
    this.certTypes = is.readVector(1);
    this.cas = is.readVector(2);

    ((ClientHandShaker)this.handShaker).processAcceptableCAs(this.cas);
  }

  /**
   * Writes the body of this CertificateRequest message to an XDROutputStream
   */
  protected void writeBody(XDROutputStream os) throws IOException
  {
    os.writeVector(1, certTypes);
    os.writeVector(2, cas);
  }
}
