//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;

import javax.net.ssl.SSLHandshakeException;

/**
 * A class for CertificateVerify Handshake message sent by a client
 * to a server during client authentication.
 *
 * @author Ming Yung
 */
final class CertificateVerify extends HandShake
{
  private byte[] signature;

  /**
   * Constructs a CertificateVerify message from an XDRInputStream with
   * a callback to the controlling ServerHandShaker
   */
  protected CertificateVerify(ServerHandShaker handShaker, byte[] data) 
    throws IOException
  {
    super(handShaker, data);

    if (Debug.debug >= Debug.DEBUG_MSG)
      Debug.debug("++ CertificateVerify");
  }

  /**
   * Constructs a CertificateVerify message with a callback to the
   * controlling ClientHandShaker.
   *
   * <p>The body of the message is the generated client signature
   */
  protected CertificateVerify(ClientHandShaker handShaker)
  {
    this.handShaker = handShaker;
    this.msgType = CERTIFICATE_VERIFY;

    try
    {
      signature = handShaker.generateClientSignature();
      this.bodyLength = signature.length + 2;
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  /**
   * Reads the body (the client signature) of this CertificateVerify 
   * message from an XDRInputStream.
   *
   * <p> The client signature is verified
   */
  protected void readBody(XDRInputStream is) 
    throws IOException
  {
    signature = is.readVector(2);
    this.bodyLength = signature.length + 2;

    try
    {
      ((ServerHandShaker)handShaker).verifyClientSignature(signature);
    }
    catch (Exception e)
    {
      e.printStackTrace();
      throw new IOException(e.toString());
    }
  }

  /**
   * Writes the body of this CertificateVerify message to an XDROutputStream
   */
  protected void writeBody(XDROutputStream os) throws IOException
  {
    os.writeVector(2, signature);
  }
}
