//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;

import javax.net.ssl.SSLHandshakeException;

/**
 * An abstracct class for ClientKeyExchange Handshake messages sent by
 * a client to a server during key exchange
 *
 * Subclassed by RSA & DH specific classes
 *
 * @author Ming Yung
 */
abstract class ClientKeyExchange extends HandShake
{
  protected byte[] exchangeKeys;

  /**
   * Constructs a ClientKeyExchange message from an XDRInputStream with
   * a callback to the controlling ServerHandShaker
   */
  protected ClientKeyExchange(ServerHandShaker handShaker, byte[] data) 
    throws IOException
  {
    super(handShaker, data);
  }

  /**
   * Default constructor
   */
  protected ClientKeyExchange() 
  {
    super();
  }
  
  /**
   * Writes the body of this ClientKeyExchange message to an XDROutputStream
   */
  protected void writeBody(XDROutputStream os) throws IOException
  {
    os.write(exchangeKeys);
  }
}
