//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;
import java.io.ByteArrayOutputStream;

import javax.crypto.interfaces.DHPublicKey;

import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

final class DHServerKeyExchange extends ServerKeyExchange
{
  /**
   * Constructs a ServerKeyExchange message from an XDRInputStream with
   * a callback to the controlling ClientHandShaker
   */
  protected DHServerKeyExchange(ClientHandShaker handShaker, byte[] data) 
    throws IOException
  {
    super(handShaker, data);

    if (Debug.debug >= Debug.DEBUG_MSG)
      Debug.debug("++ DHServerKeyExchange");
  }

  protected DHServerKeyExchange(ServerHandShaker handShaker, int keyLength) 
    throws IOException
  {
    super(handShaker, keyLength);
  }

  protected void generateParamsAndSig(XDROutputStream out)
    throws IOException
  {
    DHPublicKey pub = ((ServerHandShaker)
      handShaker).generateTempDHPubKey(this.keyLength);

    byte[] p = pub.getParams().getP().toByteArray();
    byte[] g = pub.getParams().getG().toByteArray();
    byte[] y = pub.getY().toByteArray();

    out.writeVector(2, p);
    out.writeVector(2, g); 
    out.writeVector(2, y); 
  }

  protected void verifyParamsSig(XDRInputStream is, XDROutputStream out) 
    throws IOException
  {
    byte[] p = is.readVector(2);
    byte[] g = is.readVector(2);
    byte[] y = is.readVector(2);

    ((ClientHandShaker)handShaker).setServerEncryptionKey(p, g, y); 
    out.writeVector(2, p);
    out.writeVector(2, g); 
    out.writeVector(2, y); 
  }
}
