//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;

import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

/**
 * A class for Finished Handshake messages sent to a peer as the last
 * message in a handshake
 *
 * @author Ming Yung
 */
final class Finished extends HandShake
{
  private byte[] hashBytes;

  /**
   * Constructs a Finished message from an XDRInputStream with
   * a callback to the controlling HandShaker
   */
  protected Finished(HandShaker handShaker, byte[] data) 
    throws IOException
  {
    super(handShaker, data);

    if (Debug.debug >= Debug.DEBUG_MSG)
      Debug.debug("++ Finished");
  }

  /**
   * Constructs a Finished message with a callback to the controlling
   * HandShaker.
   *
   * <p>The body of the message contains md5 and sha hashes
   */
  protected Finished(HandShaker handShaker) throws IOException
  {
    this.handShaker = handShaker;
    this.msgType = FINISHED;
    this.bodyLength = 36;

    hashBytes = handShaker.generateHashes();
  }

  /**
   * Reads the body (md5 and sha hashes) of this Finished message 
   * from an XDRInputStream
   *
   * <p>The hashes are verified.
   */
  protected void readBody(XDRInputStream is) 
    throws IOException
  {
    byte[] hashes = is.readBytes(36);
    this.bodyLength = 36;

    handShaker.checkHashes(hashes);
  }

  /**
   * Writes the body of this Finished message to an XDROutputStream
   */
  protected void writeBody(XDROutputStream os) throws IOException
  {
    os.write(hashBytes);
  }
}
