//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.net.Socket;
import java.net.InetAddress;
import java.io.IOException;
import java.util.Vector;

import java.security.SecureRandom;
import java.security.PrivateKey;

/**
 * An implementation of javax.net.ssl.SSLServerSocket whih does the
 * actual work when operations on javax.net.ssl.SSLServerSocket is called.
 *
 * @author Ming Yung
 */
final class SSLServerSocket extends javax.net.ssl.SSLServerSocket
{
  private BaseSSLServerSocketFactory sockFact = null;
  private String[] enabledCipherSuites;
  private PrivateKey privKey;
  private Vector serverCerts;
  private boolean clientAuthRequired;

  protected SSLServerSocket(BaseSSLServerSocketFactory sockFact,
                            int port, PrivateKey privKey, Vector serverCerts,
                            boolean flag, String[] enabledCipherSuites)
    throws IOException
  {
    super(port);

    init(sockFact, privKey, serverCerts, flag, enabledCipherSuites);
  }  

  protected SSLServerSocket(BaseSSLServerSocketFactory sockFact,
                            int port, int backlog, PrivateKey privKey,
                            Vector serverCerts, boolean flag,
                            String[] enabledCipherSuites)
    throws IOException
  {
    super(port, backlog);

    init(sockFact, privKey, serverCerts, flag, enabledCipherSuites);
  }  

  protected SSLServerSocket(BaseSSLServerSocketFactory sockFact,
                            int port, int backlog, InetAddress address,
                            PrivateKey privKey, Vector serverCerts,
                            boolean flag, String[] enabledCipherSuites)
    throws IOException
  {
    super(port, backlog, address);

    init(sockFact, privKey, serverCerts, flag, enabledCipherSuites);
  }  

  private void init(BaseSSLServerSocketFactory sockFact,
                    PrivateKey privKey, Vector serverCerts,
                    boolean flag, String[] enabledCipherSuites)
  {
    this.sockFact = sockFact;
    this.privKey = privKey;
    this.serverCerts = serverCerts;
    this.enabledCipherSuites = enabledCipherSuites;
    this.clientAuthRequired = flag;
  }

  public Socket accept() throws IOException
  {
    SSLSocket retval = new SSLSocket();
    implAccept(retval);

    if (Debug.debug >= Debug.DEBUG_MSG)
      Debug.debug("Client Auth required: " + clientAuthRequired);

    retval.initialize(sockFact.getRandom(), this.privKey, this.serverCerts, 
                      sockFact.getTrustedCertificates(),
                      this.enabledCipherSuites, this.clientAuthRequired, 
                      sockFact.getSessionCache());
    return retval;
  }

  public void setEnabledCipherSuites(String[] suites)
  {
    this.enabledCipherSuites = suites;
  }

  public String[] getEnabledCipherSuites()
  {
    return enabledCipherSuites;
  }

  public String[] getSupportedCipherSuites()
  {
    return CipherSuites.suiteName;
  }

  public void setEnableSessionCreation(boolean flag)
  {
  }

  public boolean getEnableSessionCreation()
  {
    return false;
  }

  public void setNeedClientAuth(boolean flag)
  {
    this.clientAuthRequired = flag;
  }

  public boolean getNeedClientAuth()
  {
    return clientAuthRequired;
  }

  public void setUseClientMode(boolean falg)
  {
  }

  public boolean getUseClientMode()
  {
    return false;
  }
}
