//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.util.Arrays;
import java.util.Date;
import java.security.cert.X509Certificate;

import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLPeerUnverifiedException;

final class SSLSession implements javax.net.ssl.SSLSession
{
  private SessionCache cache = null;
  private byte[] id = null;
  private byte[] masterSecret = null;
  private String suite = null;
  private long creationTime = 0;
  private long lastAccessTime = 0;
  private X509Certificate[] peerCertChain = null;
  private String peerHost = null;
  private boolean isValid = true;

  SSLSession(SSLSocket sock, byte[] id, byte[] secret, String suite, 
             X509Certificate[] certs)
  {
    this.cache = sock.getSessionCache();
    this.id = id;
    this.masterSecret = secret;
    this.suite = suite;
    this.creationTime = System.currentTimeMillis();
    this.lastAccessTime = this.creationTime;
    this.peerCertChain = certs;
    this.peerHost = sock.getInetAddress().getHostName();
    sock.setSession(this);
  }

  void addToCache()
  {
    this.cache.addSession(this);
  }

  public String getCipherSuite()
  {
    return this.suite;
  }

  public long getCreationTime()
  {
    return this.creationTime;
  }

  void updateAccessTime()
  {
    this.lastAccessTime = System.currentTimeMillis();
  }

  public long getLastAccessedTime()
  {
    return this.lastAccessTime;
  }

  public byte[] getId()
  {
    return this.id;
  }

  public SSLSessionContext getSessionContext()
  {
    return this.cache;
  }

  public X509Certificate[] getPeerCertificateChain()
    throws SSLPeerUnverifiedException
  {
    if (this.peerCertChain == null)
      throw new SSLPeerUnverifiedException("No certs for peer");

    return this.peerCertChain;
  }

  public String getPeerHost()
  {
    return this.peerHost;
  }

  public Object getValue(String name)
  {
    return null;
  }

  public void removeValue(String name)
  {
  }

  public String[] getValueNames()
  {
    return null;
  }

  public void putValue(String name, Object value)
  {
  }

  public void invalidate()
  {
    this.isValid = false;
  }

  boolean isValid()
  {
    return this.isValid;
  }

  byte[] getMasterSecret()
  {
    return this.masterSecret;
  }

  public String toString()
  {
    StringBuffer sb = new StringBuffer();
    sb.append("SSL Session\n");
    sb.append("  id: ");
    toHex(sb, id);
    sb.append("  cipher suite:  ").append(suite).append("\n");
    sb.append("  peer host:     ").append(peerHost).append("\n");
    sb.append("  created:       ");
    sb.append(new Date(creationTime).toString()).append("\n");
    sb.append("  last accessed: ");
    sb.append(new Date(lastAccessTime).toString()).append("\n");
    return sb.toString();
  }

  private void toHex(StringBuffer sb, byte[] data)
  {
    for (int i=0; i<data.length; i++)
    {
      sb.append(Integer.toHexString(0xff & data[i]));
    }
    sb.append("\n");
  }
}
