//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.ssl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.DataOutputStream;

/**
 * An output stream for SSL base data types defined at the record layer
 *
 * @author Ming Yung
 */
class XDROutputStream extends DataOutputStream
{
  XDROutputStream(OutputStream os)
  {
    super(os);
  }

  void write3Bytes(int i) throws IOException
  {
    byte temp[] = new byte[3];
    temp[0] = (byte)((i >> 16) & 0xff);
    temp[1] = (byte)((i >> 8) & 0xff);
    temp[2] = (byte)(i & 0xff);
    write(temp);
  }

  void writeVector(int lengthOctets, byte[] b) throws IOException
  {
    switch (lengthOctets)
    {
      case 1:
        writeByte((byte)b.length); 
        break;

      case 2: 
        writeShort(b.length);
        break;

      case 3: 
        write3Bytes(b.length);
        break;

      default: 
        writeInt(b.length);
    }

    if (b.length > 0) write(b);
  }
}
