//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.util;

import java.io.IOException;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class Config
{
  public Config() {}

  public static Properties getProperties(String sysPropKey, String propName) 
    throws ConfigException 
  {
    Properties retval = new Properties();

    String sysProp = System.getProperty(sysPropKey);
    if (sysProp != null)
    {
      try
      {
        retval.load(new FileInputStream(sysProp));
        return retval;
      }
      catch (IOException e)
      {
        throw new ConfigException(e.getMessage());
      }
    }

    String[] locations = 
    {
      System.getProperty("java.home") + File.separator + "lib" 
        + File.separator + propName,
      System.getProperty("user.home")  + File.separator + ".jcsi" 
        + File.separator + propName,
      System.getProperty("user.dir")  + File.separator + ".jcsi" 
        + File.separator + propName
    };

    int ind = 0;
    while (ind < locations.length)
    {
      try
      {
        retval.load(new FileInputStream(locations[ind]));
        return retval;
      }
      catch (IOException e)
      {
        ind++;
      }
    }

    throw new ConfigException ("property file " + propName + " not found");
  }
}
