//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.x509;

import java.io.*;

/**
 * A FilterInputStream for base-64 encoded data
 *
 * @author Ming Yung
 */
public class Base64InputStream extends FilterInputStream
{
  private byte[] headerBytes = null;
  private byte[] footerBytes = null;

  public Base64InputStream(InputStream is, String header, String footer)
  {
    super(is);

    if (header == null) return;

    try
    {
      this.headerBytes = header.getBytes();
      while (is.available() > 0)
      {
        if (is.read() == headerBytes[0])
          break;
      }

      byte[] skipped = new byte[this.headerBytes.length];
      is.read(skipped);
      this.footerBytes = footer.getBytes();
    }
    catch (Exception e)
    {
      //Shouldn't happen
      System.out.println(e.toString());
    }
  }

  public int available() throws IOException
  {
    return (in.available())*4/5;
  }

  public int read(byte[] b) throws IOException
  {
    int offset = 0;
    byte[] input = new byte[4];

    while (true)
    {
      if (offset >= b.length) break;

      int count = 0;

      //read four non-whitespace characters, one at a time
      while (count < 4)
      {
        int next = this.in.read();
        if (next == -1)
        {
          if (count > 0)
            throw new IOException("Unexpected end of data encountered");

          return offset;
        }

        if (footerBytes != null)
        {
          if (next == footerBytes[0]) 
          {
            //read till end of footer
            this.in.skip(footerBytes.length);
            return offset;
          }
        }

        //valid data
        if (next >= 43 && next <= 122)
        {
          input[count] = (byte)next;
          count++;
        }
      }

      //base64decode
      System.arraycopy(fromBase64(input), 0, b, offset, 3); 
      offset += 3;
    }
    return offset;
  }

  //4 chars to 3 bytes
  private static final byte[] fromBase64(byte[] in)
  {
    byte retval[] = new byte[3];
    int index[] = new int[4];

    for (int i=0; i<4; i++)
    {
      byte current = in[i];
  
      if (current > 0x60)
      {
        index[i] = current - 71;
      }
      else if (current > 0x40)
      {
        index[i] = current - 65;
      }
      else if (current > 0x2f)
      {
        index[i] = current  + 4;
      }
      else if (current == 0x2b)
      {
        index[i] = 62;
      }
      else if (current == 0x2f)
      {
        index[i] = 63;
      }
    }

    retval[0] = (byte)((index[0] & 0xff) << 2 | (index[1] & 0xff) >> 4); 
    retval[1] = (byte)((index[1] & 0xff) << 4 | (index[2] & 0xff) >> 2);
    retval[2] = (byte)((index[2] & 0xff) << 6 | (index[3] & 0xff));
    return retval;
  }
}
