//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.x509;

import java.security.cert.X509Certificate;

import java.util.Set;
import java.util.HashSet;
import com.dstc.security.x509.extns.*;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Boolean;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.provider.OID;

/**
 * A factory class for Extensions
 *
 * @author Ming Yung
 */
public class ExtensionFactory
{
  public static Extension getExtension(byte encoded[]) 
  {
    try
    {
      Extension ext = new Extension(encoded);
      if (ext.getExtnID().equals(OID.netscapeCertType))
        return new NetscapeCertType(encoded);

      if (ext.getExtnID().equals(OID.basicConstraints))
        return new BasicConstraints(encoded);

      if (ext.getExtnID().equals(OID.authorityKeyIdentifier))
        return new AuthorityKeyIdentifier(encoded);

      if (ext.getExtnID().equals(OID.subjectKeyIdentifier))
        return new SubjectKeyIdentifier(encoded);

      if (ext.getExtnID().equals(OID.keyUsage))
        return new KeyUsage(encoded);

      if (ext.getExtnID().equals(OID.issuerAltName))
        return new IssuerAltName(encoded);

      if (ext.getExtnID().equals(OID.subjectAltName))
        return new SubjectAltName(encoded);

      return ext;
    }
    catch (Exception e)
    {
      e.printStackTrace();
      return null;
    }
  }

  public static Extension getExtension(String oid, X509Certificate cert)
  {
    byte[] encoded = cert.getExtensionValue(oid);
    if (encoded == null)
      return null;

    Sequence seq = new Sequence();

    try
    {
      seq.addComponent(new Oid(oid));
      seq.addComponent(Asn1.decode(encoded));
    }
    catch (Asn1Exception e)
    {
      e.printStackTrace();
      return null;
    }

     return getExtension(seq.encode());
  }
}
