//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.x509;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Boolean;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Asn1Exception;

/**
 * <p>A class representing the x.509 ASN.1 structure Extensions
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public class Extensions extends Sequence
{
  //Vector of Extension objects
  private Vector extns;

  /**
   * Constructs an Extensions object from given Set of extensions
   */
  public Extensions(Vector extns) throws Asn1Exception
  {
    this.extns = extns;

    Iterator it = extns.iterator();
    while (it.hasNext())
    {
      addComponent(new Extension(((Asn1)it.next()).encode()));
    }
  }

  /**
   * Constructs an Extensions from a DER encoding
   */
  public Extensions(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);

    this.extns = new Vector();
    for (int i=0; i<components.size(); i++)
    {
      extns.add(ExtensionFactory.getExtension(((Asn1)components.
          elementAt(i)).encode()));
    }
  }

  public Set getCriticalOIDs()
  {
    HashSet retval = new HashSet();
    Iterator it = extns.iterator();
    while (it.hasNext())
    {
      Extension extn = (Extension)it.next();
      if (extn.isCritical())
      {
        retval.add(extn.getExtnID());
      }
    }
    return retval;
  }

  public Set getNonCriticalOIDs()
  {
    HashSet retval = new HashSet();
    Iterator it = extns.iterator();
    while (it.hasNext())
    {
      Extension extn = (Extension)it.next();
      if (!extn.isCritical())
      {
        retval.add(extn.getExtnID());
      }
    }
    return retval;
  }

  /**
   * Returns the DER-encoded OctetString for the extension value
   */
  public byte[] getValue(String oid)
  {
    Iterator it = extns.iterator();
    while (it.hasNext())
    {
      Extension extn = (Extension)it.next();
      if(extn.getExtnID().equals(oid))
        return extn.getExtnValue();
    }
    return null;
  }

  public String toString()
  {
    StringBuffer retval = new StringBuffer();

    Iterator it = extns.iterator();
    while (it.hasNext())
    {
      retval.append(((Extension)it.next()).toString());
    }
    return retval.toString();
  }
}
