//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.x509;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Asn1Exception;

/**
 * <p>A class representing x.509 ASN.1 structure GeneralNames.
 * 
 * <pre>
 *     GeneralNames ::= SEQUENCE SIZE (1..MAX) OF GeneralName
 * </pre>
 */
public class GeneralNames extends Sequence
{
  private Set names;

  /**
   * Constructs a GeneralNames from a Set of GeneralName
   */
  public GeneralNames(Set names)
  {
    this.names = names;

    Iterator it = names.iterator();
    while (it.hasNext())
    {
      addComponent((GeneralName)it.next());
    }
  }

  /**
   * Constructs a GeneralNames from a DER encoding
   */
  public GeneralNames(byte[] encoded) throws Asn1Exception
  {
    doDecode(encoded);

    this.names = new HashSet();
    for (int i=0; i<components.size(); i++)
    {
      this.names.add(new GeneralName(((Asn1)components.elementAt(i)).encode()));
    }
  }

  /**
   * Returns the Set of GeneralName
   */
  public Set getNames()
  {
    return this.names;
  }
}

