//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.x509.extns;

import java.util.Vector;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Boolean;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.provider.OID;
import com.dstc.security.x509.Extension;
import com.dstc.security.x509.GeneralNames;
import com.dstc.security.x509.GeneralName;

/**
 * A class representing the X.509 ASN.1 structure SubjectAltName.
 *
 * <pre>
 *     SubjectAltName ::= GeneralNames
 *
 *     GeneralNames ::= SEQUENCE SIZE (1..MAX) OF GeneralName
 * </pre>
 */
public class SubjectAltName extends Extension
{
  private String val;

  /**
   * Constructs a SubjectAltName extension with a single email address
   * (critical).
   */
  public SubjectAltName(String email)
  {
    this.extnID = OID.subjectAltName;
    this.addComponent(new Oid(OID.subjectAltName));

    this.critical = true;
    this.addComponent(new Boolean(1));

    this.val = email;
    Set names = new HashSet();
    names.add(new GeneralName(GeneralName.RFC822NAME, email));
    OctetString oct = new OctetString((new GeneralNames(names)).encode());
    this.extnValue = oct.encode();
    this.addComponent(oct);
  }

  /**
   * Constructs a SubjectAltName from a DER encoding
   */
  public SubjectAltName(byte encoded[]) throws Asn1Exception
  {
    super(encoded);

    Iterator it = (new GeneralNames(this.value)).getNames().iterator();
    GeneralName name = (GeneralName)it.next();
    this.val = name.getName();
  }

  /**
   * Returns the name in this SubjectAltName
   */
  public String getName()
  {
    return this.val;
  }

  public String toString()
  {
    StringBuffer sb = new StringBuffer();

    sb.append("SubjectAltName extension:\n");
    sb.append("  " + this.val + "\n");

    return sb.toString();
  }
}
