//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.provider.OID;
import com.dstc.security.x509.Extension;

/**
 * Class representing the ASN.1 structure structure SubjectKeyIdentifier.
 *
 * <pre>
 *  SubjectKeyIdentifier ::= KeyIdentifier
 *
 *  KeyIdentifier ::= OCTET STRING
 * </pre>
 * @author Ming Yung
 */
public class SubjectKeyIdentifier extends Extension
{
  private byte[] keyId;

  /**
   * Constructs a SubjectKeyIdentifier extension (non-critical).
   */
  public SubjectKeyIdentifier(boolean dummy, byte[] keyId)
  {
    this.extnID = OID.subjectKeyIdentifier;
    this.addComponent(new Oid(this.extnID));
 
    this.keyId = keyId;
    this.extnValue = (new OctetString(keyId)).encode();
    this.addComponent(new OctetString(this.extnValue));
  }

  /**
   * Constructs a SubjectKeyIdentifier extension from a DER encoding
   */
  public SubjectKeyIdentifier(byte[] encoded) throws Asn1Exception
  {
    super(encoded);
    this.keyId = ((OctetString)Asn1.decode(this.value)).getBytes();
  }

  /**
   * Returns the keyID for this SubjectKeyIdentifier extension
   */
  public byte[] getKeyID()
  {
    return this.keyId;
  }

  public String toString()
  {
    StringBuffer sb = new StringBuffer();

    sb.append("SubjectKeyIdentifier extension:\n");
    sb.append("  " + printHex(this.keyId));
    return sb.toString();
  }
}
