//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package javax.net;

import java.io.*;
import java.net.*;

/**
 * <p> This class creates server sockets. It may be subclassed by other
 * factories, which create particular types of server sockets. This
 * provides a general framework for the addition of public socket-level
 * functionality. It it is the server side analogue of a socket factory,
 * and similarly provides a way to capture a variety of policies related
 * to the sockets being constructed.
 *
 * <p> Like socket factories, Server Socket factory instances have methods
 * used to create sockets. There is also an environment specific default
 * server socket factory; frameworks will often use their own customized
 * factory.
 *
 * @version 0.98, 98/09/10
 * @author Ming Yung
 *
 */

public abstract class ServerSocketFactory 
{
  /**
   * Constructor is used only by subclasses.
   */
  protected ServerSocketFactory()
  {
  }

  /**
   * Returns a copy of the environment's default server socket factory.
   */
  public static ServerSocketFactory getDefault()
  {
    return null;
  }

  /**
   * Returns a server socket which uses all network interfaces on the host,
   * and is bound to the specified port.
   *
   * @param port  the port to listen to
   *
   * @throw IOException for networking errors
   */
  public abstract ServerSocket createServerSocket(int port) 
    throws IOException;

  /**
   * Returns a server socket which uses all network interfaces on the host,
   * is bound to a the specified port, and uses the specified
   * connection backlog. The socket is configured with the socket
   * options (such as accept timeout) given to this factory.
   *
   * @param port  the port to listen to
   * @param backlog  how many connections are queued
   * 
   * @throw IOException for networking errors
   */
  public abstract ServerSocket createServerSocket(int port, int backlog) 
    throws IOException; 

  /**
   * Returns a server socket which uses only the specified network
   * interface on the local host, is bound to a the specified port,
   * and uses the specified connection backlog. The socket is
   * configured with the socket options (such as accept timeout)
   * given to this factory.
   *
   * @param port  the port to listen to
   * @param backlog  how many connections are queued
   * @param ifAddress  the network interface address to use
   * 
   * @throw IOException for networking errors
   */
  public abstract ServerSocket createServerSocket(int port, int backlog,
                                                  InetAddress ifAddress) 
    throws IOException; 


}
