//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package jcsi.servlet;

import java.util.Properties;
import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

import com.dstc.security.util.Config;
import com.dstc.security.util.ConfigException;
import com.dstc.security.x509.Base64OutputStream;
import com.dstc.security.asn1.*;

/**
 * A servlet which returns the CA certificate
 *
 * @version 0.98, 98/11/01
 * @author Ming Yung
 */
public class CACertServlet extends HttpServlet
{ 
  private static final String CA_CONF = "jcsi.ca.conf";
  private static final String CA_PROPERTIES = "ca.properties";

  public void doPost(HttpServletRequest req, HttpServletResponse res) 
    throws ServletException, IOException
  {
    Properties props;

    try
    {
      props = Config.getProperties(CA_CONF, CA_PROPERTIES);
    }
    catch (ConfigException e)
    {
      throw new ServletException(e.getMessage());
    }

    String keyDir = (String)props.getProperty("jcsi.ca.key.dir");

    //Retrieve cert
    FileInputStream in 
      = new FileInputStream(keyDir + File.separator
          + (String)props.getProperty("jcsi.ca.cert"));

    byte encoded[] = new byte[in.available()];
    in.read(encoded);
    in.close();

    // set content type and other response header fields first
    res.setContentType("application/x-x509-ca-cert");

    // then write the data of the response
    Base64OutputStream bos 
      = new Base64OutputStream(res.getOutputStream(),
                               "-----BEGIN CERTIFICATE-----",
                               "-----END CERTIFICATE-----");
    bos.write(encoded);
    bos.flush();
  }
}
