package jcsi;

import java.rmi.*;
import java.rmi.registry.*;
import java.rmi.server.*;
import java.io.*;

public class EchoClient
{
  public static void main(String[] args) 
  {
    try
    {
      if (System.getSecurityManager() == null)
        System.setSecurityManager(new RMISecurityManager());

      Echo client = (Echo)Naming.lookup("/EchoServer");

      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader ir = new BufferedReader(isr);

      while (true)
      {
        System.out.print("> ");
        String in = ir.readLine();
        System.out.println(client.echo(in));
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  public String echo(String in) throws RemoteException
  {
    return in;
  }
}
