//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package jcsi;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.OutputStream;
import java.net.Socket;

import java.security.cert.X509Certificate;

import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;

public class SSLClient
{
  private static final boolean debug = false;

  //host, port
  public static void main(String args[])
  {
    Socket sock = null;

    try
    {
      SocketFactory fact = javax.net.ssl.SSLSocketFactory.getDefault();
      sock = fact.createSocket(args[0], Integer.parseInt(args[1]));

      System.out.println("");

      OutputStream os = sock.getOutputStream();
      String req = "GET / HTTP/1.0\r\n" +
                   //"Connection: Keep-Alive\r\n" +
                   "User-Agent: Java SSL Client\r\n" +
                   "\r\n";
      os.write(req.getBytes());
      os.flush();

      InputStream is = sock.getInputStream();
       
      if (debug)
        System.out.println("waiting for input");

      InputStreamReader isr = new InputStreamReader(is);
      BufferedReader in = new BufferedReader(isr);

      while (true)
      {
        String next = in.readLine();
        if (next == null) break;

        System.out.println(next);
      }

      System.out.println("\n********************");
      X509Certificate[] certs 
        = ((SSLSocket)sock).getSession().getPeerCertificateChain();
      for (int i=0; i<certs.length; i++)
      {
        System.out.println(certs[i].toString());
      }
      System.out.println("********************");

      is.close();
      os.close();

      sock.close();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }
}
