# **********************************************************************
#
# Copyright (c) 1999
# Object Oriented Concepts, Inc.
# Billerica, MA, USA
#
# All Rights Reserved
#
# **********************************************************************

# ----------------------------------------------------------------------
# Define OPTIMIZE as "yes" to build ORBacus with optimizations turned
# on.
#
# NOTE: If you change this option later, you need to completely
# rebuild ORBacus. (Using "nmake /f Makefile.mak clean", and "nmake /f
# Makefile.mak" after that.)
# ----------------------------------------------------------------------

#OPTIMIZE=yes
OB_DIR=$(prefix)

# ----------------------------------------------------------------------
# Define OLD_IOSTREAM as "yes" if you want to use the old iostream
# library, i.e., if you want to use '#include <iostream.h>" instead of
# "#include <iostream>". 
#
# NOTE: If you want to check your application with "purify", please
# use the old iostream library instead of the new one. If the new one
# is used, purify will detect lots of non-existent memory problems.
# ----------------------------------------------------------------------

#OLD_IOSTREAM=yes

# ----------------------------------------------------------------------
# If you want to make use of a Dynamic Link Library (DLL) instead of a
# static library in the packages where this is supported, uncomment
# the following line to define DLL as "yes". Note that in this case
# you need "perl" for the compilation process.
#
# NOTE: If you want to compile ORBacus with JThreads/C++ support as
# a DLL, you must also compile JThreads/C++ as a DLL.  When using
# the DLL version of ORBacus or JThreads/C++, you must not specify a 
# statically linked runtime library with the /MT, /MTd, /ML or /MLd 
# compiler flags. 
# ----------------------------------------------------------------------

#DLL=yes

# ----------------------------------------------------------------------
# If you want to compile ORBacus with JThreads/C++ support, or if
# you want to compile some other package based on an ORBacus
# version which was compiled with JThreads/C++ support, uncomment the
# following line to define WITH_JTC as "yes".
# ----------------------------------------------------------------------

#WITH_JTC=yes

# ----------------------------------------------------------------------
# If you are compiling JThreads/C++, and you want support for the
# stop, suspend and resume operations, uncomment the following line to
# define WITH_JTC_STOP as "yes".
#
# NOTE: ORBacus does not require support for stop, suspend or resume,
# so it's safe (and about 10% faster) to leave this option untouched.
# ----------------------------------------------------------------------

#WITH_JTC_STOP=yes

# ----------------------------------------------------------------------
# Use the following lines to set your installation directories
# ----------------------------------------------------------------------

prefix          = C:\OOC
bindir          = $(prefix)\bin
libdir          = $(prefix)\lib
includedir      = $(prefix)\include

# ----------------------------------------------------------------------
# If JThreads/C++ support is enabled, use the following line to set
# the JThreads/C++ installation path.
# ----------------------------------------------------------------------

JTC_DIR=$(prefix)

# ----------------------------------------------------------------------
# If you compile any program that depends on ORBacus (for example
# ORBacus SSL), use the following line to set the ORBacus installation
# path.
# ----------------------------------------------------------------------

OB_DIR=$(prefix)

# ----------------------------------------------------------------------
# Experts only: You can modify the lines below, for example to change
# the settings for code optimizations.
# ----------------------------------------------------------------------

!if "$(OPTIMIZE)" == "yes"

#
# These options are for building ORBacus with optimizations turned on.
# See Microsoft's compiler documentation for more information on the
# /O flag. Please note that debug information is automatically
# disabled by the Microsoft compiler when optimization is enabled.
#
OPT_CXXFLAGS    = /Ox 
OPT_LINKFLAGS   =
OPT_CPPFLAGS	= /DNDEBUG

!else

#
# These options are for building ORBacus with debug information, and
# no optimization.
#
OPT_CXXFLAGS    = /Od /Zi
OPT_LINKFLAGS   = /debug
OPT_CPPFLAGS	=

!endif

CXX             = cl.exe
CXXFLAGS        = /nologo /MD /W3 /GX /Gy $(OPT_CXXFLAGS)
CXXCPP          = cl.exe /nologo /E
CPPFLAGS        = /DWIN32 $(OPT_CPPFLAGS) # /DOB_CLEAR_MEM
LIBS		= 
GUILIBS         = /defaultlib:user32.lib gdi32.lib winmm.lib \
		  comdlg32.lib comctl32.lib
DLLLIBS         = /defaultlib:user32.lib
LINK		= link.exe
LINKFLAGS	= /nologo $(OPT_LINKFLAGS) /subsystem:console /incremental:no
LINKGUIFLAGS	= /nologo $(OPT_LINKFLAGS) /subsystem:windows /incremental:no
LINKDLLFLAGS	= /nologo $(OPT_LINKFLAGS) /dll /incremental:no
AR		= lib.exe
ARFLAGS		= /nologo

SHELL		= bash # Only needed for "nmake /f Makefile.mak test"

# ----------------------------------------------------------------------
# Don't change anything below this line
# ----------------------------------------------------------------------

!ifndef INCLUDE
!error The INCLUDE environment variable needs to be set.
!endif
!ifndef LIB
!error The LIB environment variable needs to be set.
!endif

.SUFFIXES:
.SUFFIXES:	.cpp .obj

.cpp.obj::
	$(CXX) /c $(ALL_CPPFLAGS) $(ALL_CXXFLAGS) $<

all:: $(TARGETS)

clean::
	@del /q *.obj *.bak *.flc *.pdb *.pch

!if "$(TARGETS)" != ""
clean::
	@for %i in ( $(TARGETS) ) do \
	    @if exist %i del /q %i
!endif

install::

test::

lib:
	mkdir $@

bin:
	mkdir $@
