dnl **********************************************************************
dnl
dnl Copyright (c) 1999
dnl Object Oriented Concepts, Inc.
dnl Billerica, MA, USA
dnl
dnl All Rights Reserved
dnl
dnl **********************************************************************

dnl ----------------------------------------------------------------------
dnl Check whether c++ compiler supports RTTI
dnl ----------------------------------------------------------------------

AC_CACHE_CHECK(whether c++ compiler supports RTTI,
ac_cv_rtti,
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_TRY_COMPILE_GLOBAL(
,
struct X { virtual ~X() { } };
struct Y : virtual public X { virtual ~Y() { } };
void f() { Y y; X* xp = &y; Y* yp = dynamic_cast<Y*>(xp); }
,
ac_cv_rtti=yes, ac_cv_rtti=no)
AC_LANG_RESTORE)

if test $ac_cv_rtti = no
then
    AC_DEFINE(HAVE_NO_RTTI)
fi

dnl ----------------------------------------------------------------------
dnl Check whether c++ compiler supports exception handling
dnl ----------------------------------------------------------------------

AC_CACHE_CHECK(whether c++ compiler supports exception handling,
ac_cv_exception_handling,
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_TRY_COMPILE_GLOBAL(
,
void f() { throw "abc"; }
void g() { try { f(); } catch(char*) { } }
,
ac_cv_exception_handling=yes, ac_cv_exception_handling=no)
AC_LANG_RESTORE)

if test $ac_cv_exception_handling = no
then
    AC_MSG_ERROR(Compiler does not support exception handling!)
fi

dnl ----------------------------------------------------------------------
dnl Check whether c++ compiler supports namespaces
dnl ----------------------------------------------------------------------

AC_CACHE_CHECK(whether c++ compiler supports namespaces,
ac_cv_namespace,
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_TRY_COMPILE_GLOBAL(
,
namespace N { typedef int I; }; N::I i;
,
ac_cv_namespace=yes, ac_cv_namespace=no)
AC_LANG_RESTORE)

if test $ac_cv_namespace = no
then
    AC_DEFINE(HAVE_NO_NAMESPACE)
fi

dnl ----------------------------------------------------------------------
dnl Check whether c++ compiler supports the namespace std
dnl ----------------------------------------------------------------------

if test $ac_cv_namespace = yes
then
    AC_CACHE_CHECK(whether c++ compiler supports the namespace std,
    ac_cv_std_namespace,
    AC_LANG_SAVE
    AC_LANG_CPLUSPLUS
    if test $ac_cv_header_iostream = yes
    then
    AC_TRY_COMPILE_GLOBAL(
    ,
    #include <iostream>
    using namespace std;
    ,
    ac_cv_std_namespace=yes, ac_cv_std_namespace=no)
    else
    AC_TRY_COMPILE_GLOBAL(
    ,
    #include <iostream.h>
    using namespace std;
    ,
    ac_cv_std_namespace=yes, ac_cv_std_namespace=no)
    fi
    AC_LANG_RESTORE)

    if test $ac_cv_std_namespace = yes
    then
	AC_DEFINE(HAVE_STD_NAMESPACE)
    fi
fi

dnl ----------------------------------------------------------------------
dnl Check whether c++ compiler can explicitly instantiate templates
dnl ----------------------------------------------------------------------

AC_CACHE_CHECK(whether c++ compiler can explicitly instantiate templates,
ac_cv_explicit_templates,
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_TRY_COMPILE_GLOBAL(
,
template<class T> class X { T t; }; template class X<int>; X<int> x;
,
ac_cv_explicit_templates=yes, ac_cv_explicit_templates=no)
AC_LANG_RESTORE)

if test $ac_cv_explicit_templates = no
then
    AC_DEFINE(HAVE_NO_EXPLICIT_TEMPLATES)
fi

dnl ----------------------------------------------------------------------
dnl Check whether c++ compiler can overload const type conversions
dnl ----------------------------------------------------------------------

AC_CACHE_CHECK(whether c++ compiler can overload const type conversions,
ac_cv_const_type_conversion_overload,
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_TRY_COMPILE_GLOBAL(
,
struct X { int* p_; X(int* p) : p_(p) { }
operator int&() { return *p_; } operator const int&() const { return *p_; }
operator int*() { return p_; } operator const int*() const { return p_; } };
void f() { int i = 1; int j = 2;
X x(&i); const X cx(&j); int k = x; int l = cx; k = *x; l = *cx; }
,
ac_cv_const_type_conversion_overload=yes,
ac_cv_const_type_conversion_overload=no)
if test $ac_cv_const_type_conversion_overload = yes
then
    AC_TRY_COMPILE_GLOBAL(
    ,
    struct X { int* p_; X(int* p) : p_(p) { }
    operator int&() { return *p_; } operator int() const { return *p_; } };
    void f() { int i = 1; int j = 2;
    X x(&i); const X cx(&j); int k = x; int l = cx; }
    ,
    ac_cv_const_type_conversion_overload=yes,
    ac_cv_const_type_conversion_overload=no)
fi
AC_LANG_RESTORE)

if test $ac_cv_const_type_conversion_overload = no
then
    AC_DEFINE(HAVE_NO_CONST_TYPE_CONVERSION_OVERLOAD)
fi

dnl ----------------------------------------------------------------------
dnl Check whether c++ compiler supports typename
dnl ----------------------------------------------------------------------

AC_CACHE_CHECK(whether c++ compiler supports typename,
ac_cv_typename,
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_TRY_COMPILE_GLOBAL(
,
template<class T> class X { typedef typename T::Y Y; };
class Z { typedef int Y; };
X<Z> x;
,
ac_cv_typename=yes, ac_cv_typename=no)
AC_LANG_RESTORE)

if test $ac_cv_typename = no
then
    AC_DEFINE(HAVE_NO_TYPENAME)
fi

dnl ----------------------------------------------------------------------
dnl Check whether c++ compiler knows mutable
dnl ----------------------------------------------------------------------

AC_CACHE_CHECK(whether c++ compiler knows mutable,
ac_cv_mutable,
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
AC_TRY_COMPILE_GLOBAL(
,
class X { mutable int i; }; X x;
,
ac_cv_mutable=yes, ac_cv_mutable=no)
AC_LANG_RESTORE)

if test $ac_cv_mutable = no
then
    AC_DEFINE(HAVE_NO_MUTABLE)
fi
