// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <OB/Util.h>
#include <OB/CosTypedEventChannelAdmin.h>

#include <TimerUpdate.h>

#include <stdlib.h>

#ifdef HAVE_UNISTD_H
#   include <unistd.h>
#endif

#include <stdio.h>
#include <time.h>

int
main(int argc, char* argv[], char*[])
{
    try
    {
        //
        // Create ORB.
        //
        CORBA_ORB_var orb = CORBA_ORB_init(argc, argv);

	orb -> conc_model(CORBA_ORB::ConcModelBlocking);

	//
	// Get event channel.
	//
	CORBA_Object_var obj;

	try
	{
	    obj = orb -> resolve_initial_references("TypedEventService");
	}
	catch(const CORBA_ORB::InvalidName&)
	{
	    cerr << argv[0] << ": can't resolve `TypedEventService'" << endl;
	    return 1;
	}

	if(CORBA_is_nil(obj))
	{
	    cerr << argv[0] << ": `TypedEventService' is a nil object "
		 << "reference" << endl;
	    return 1;
	}

	CosTypedEventChannelAdmin_TypedEventChannel_var e =
	    CosTypedEventChannelAdmin_TypedEventChannel::_narrow(obj);

	if(CORBA_is_nil(e))
	{
	    cerr << argv[0]
		 << ": `EventService' is not an EventChannel object reference"
		 << endl;
	    return 1;
	}

	//
	// Get TypedProxyPushConsumer.
	//
	CosTypedEventChannelAdmin_TypedSupplierAdmin_var supplierAdmin =
	    e -> for_suppliers();
	CosTypedEventChannelAdmin_TypedProxyPushConsumer_var consumer;
	try
	{
	    consumer = supplierAdmin ->
		obtain_typed_push_consumer("IDL:event/TimerUpdate:1.0");
	}
	catch(const CosTypedEventChannelAdmin_InterfaceNotSupported&)
	{
	    cerr << "InterfaceNotSupported" << endl;
	    return 1;
	}

	CORBA_Object_ptr typedConsumer = consumer -> get_typed_consumer();

	TimerUpdate_var timer = TimerUpdate::_narrow(typedConsumer);
	assert(!CORBA_is_nil(timer));

	while(true)
	{
	    char str[256];
	    time_t clock;

	    clock = time(0);
	    sprintf(str, "PushSupplier says: %s", ctime(&clock));
	    str[strlen(str) - 1] = 0;

	    try
	    {
		timer -> time_update(str);
	    }
	    catch(CORBA_SystemException& ex)
	    {
		OBPrintException(ex);
		return 1;
	    }

    #ifdef WIN32
	    Sleep(1000);
    #else
	    sleep(1);
    #endif
	}

	consumer -> disconnect_push_consumer();
    }
    catch(CORBA_SystemException& ex)
    {
        OBPrintException(ex);
        return 1;
    }
 
    return 0;
}
